﻿//handleBarsHelpers.js

function formatForId(currentValue) {
    if (!currentValue)
        return;
    var replaceSpaces = new RegExp(/\s+/g);
    return currentValue.toString().replace(replaceSpaces, "");
};

Handlebars.registerHelper("formatForId", function (currentValue) {
    return formatForId(currentValue);
});

Handlebars.registerHelper("formatDate", function (currentValue) {
    var formattedDate = (currentValue == null || currentValue == "") ? '' : formatToDateTime(currentValue);
    return formattedDate;
});

Handlebars.registerHelper("isChecked", function (currentValue, checkBoxId) {
    if (currentValue) {
        setTimeout(function () {
            if (document.getElementById(checkBoxId)) {
                document.getElementById(checkBoxId).checked = currentValue;
            }
        }, 45);
    }
});

Handlebars.registerHelper("selectItemFromDropDown", function (selectId, itemValue) {
    // need a time out on this one because the selects are not rendered just yet.
    setTimeout(function () {
        $("#" + selectId + " > option").each(function () {
            if (this.value == itemValue) {
                $(this).attr("selected", "selected");
            }
        });
    }, 40);
});

Handlebars.registerHelper("formatCurrency", function (itemValue) {
    return formatCurrency(itemValue);
});

Handlebars.registerHelper("userFormattedDate", function (itemValue) {
    return formatAsUserSpecificDate(itemValue);
});

Handlebars.registerHelper('toUpperCase', function (value) {
    if (value) {
        return new Handlebars.SafeString(value.toUpperCase());
    } else {
        return '';
    }
});

Handlebars.registerHelper('toTitleCase', function (value) {
    if (value) {
        value = value.replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase(); });
        return new Handlebars.SafeString(value);
    } else {
        return '';
    }
});

Handlebars.registerHelper("selectItemFromDropDownPreference", function (selectId, itemValue) {
    // need a time out on this one because the selects are not rendered just yet.
    setTimeout(function () {
        $("#" + selectId + " > option").each(function () {
            if (this.value == Math.floor(itemValue)) {
                $(this).attr("selected", "selected");
            }
        });
    }, 40);
});