﻿var _systemTimeZone;
var _userTimeZone;

$(function () {
    initUserTimeZones();
});

function initUserTimeZones() {
    setSystemDefaultTimeZone();
    setUserTimeZone();
    setUpPageLevelUserFormattedDates();
};

function setSystemDefaultTimeZone() {
    //For the first phase, we are defaulting to EST/EDT
    _systemTimeZone = "America/New_York";
    moment.tz.setDefault(_systemTimeZone);
};

function getSystemDefaultTimeZone() {
    return _systemTimeZone;
};

function setUserTimeZone() {
    var userTimeZoneCookieValue = readCookie("userTimeZone");
    if (isNullOrWhiteSpace(userTimeZoneCookieValue)) {
        _userTimeZone = getUserSpecificTimeZoneById(_orderDataBag.userTimeZone);
    } else {
        _userTimeZone = getUserSpecificTimeZoneById(parseInt(userTimeZoneCookieValue));
    }    
    if (_userTimeZone === "") {
        _userTimeZone = getSystemDefaultTimeZone();
    }
};

function getUserTimeZone() {
    return _userTimeZone;
};

function formatAsUserSpecificDate(dateAndTime, fromTimeZone, toTimeZone, dateTimeFormat) {

    if (!_userTimeZone) {
        initUserTimeZones();
    }
    /// <summary>
    /// Formats as user specific date.
    /// </summary>
    /// <param name="dateAndTime">The date and time.</param>
    /// <param name="fromTimeZone">From time zone.</param>
    /// <param name="toTimeZone">The to time zone.</param>
    /// <param name="dateTimeFormat">The date time format.</param>
    /// <returns>Returns the converted time from fromTimeZone to toTimeZone with the format of dateTimeFormat.</returns>
    if (!isValidDate(dateAndTime)) { //if not a valid Date, return the original string
        return dateAndTime;
    }
    if (typeof fromTimeZone == "undefined") { fromTimeZone = null; }
    if (typeof toTimeZone == "undefined") { toTimeZone = null; }
    if (typeof dateTimeFormat == "undefined") { dateTimeFormat = null; }

    var updatedDateAndTime = moment.tz(dateAndTime, "MM/DD/YYYY hh:mm A z", (fromTimeZone == null ? getSystemDefaultTimeZone() : fromTimeZone));
    if (!updatedDateAndTime.isValid()) {
        updatedDateAndTime = moment(dateAndTime).format("MM/DD/YYYY hh:mm A");
        updatedDateAndTime = moment.tz(updatedDateAndTime, "MM/DD/YYYY hh:mm A z", (fromTimeZone == null ? getSystemDefaultTimeZone() : fromTimeZone));
    }
    updatedDateAndTime = updatedDateAndTime.clone().tz((toTimeZone == null ? getUserTimeZone() : toTimeZone)).format((dateTimeFormat == null ? "MM/DD/YYYY hh:mm A z" : dateTimeFormat));
    return updatedDateAndTime;
};

function getUserSpecificTimeZoneById(userTimeZoneId) {
    //ID Values match up to the system default IDs
    switch (userTimeZoneId) {
        case 1: //Samoa Time Zone
            return "Pacific/Samoa";
        case 2: //Hawaii-Aleutian Time Zone
            return "Pacific/Honolulu";
        case 3: //Alaska Time Zone
            return "America/Anchorage";
        case 4: //Pacific Time Zone
            return "America/Los_Angeles";
        case 5: //Mountain Time Zone
            return "America/Denver";
        case 6: //Central Time Zone
            return "America/Chicago";
        case 7: //Eastern Time Zone
            return "America/New_York";
        case 8: //Atlantic Time Zone
            return "Atlantic/Bermuda";
        case 9: //Chamorro Time Zone
            return "Pacific/Guam";
        default:
            return "";
    }
};

function setUpPageLevelUserFormattedDates() {
    $(".userFormattedDate").each(function (index) {
        if (isValidDate($(this).html())) {   
            $(this).html(formatAsUserSpecificDate($(this).html()));
        }
    });
};