﻿var um_btnChangePass;
var um_hdnEmails;
var um_email;
var um_currentPasswordtxt;
var um_passwordtxt;
var um_passwordConfrmtxt;
var um_qualifiedId;
var acc_securityQuestionCount;
var acc_securityQuestions;
var acc_btnPasswordChange = 0;
var user;
var um_hdnContactId;
var um_userpw;
var lastLoginDateSplit;
var initialHomeOffice;
var initialLstBranch;
var initialLstTimeZone;
var deleteBranchLaunch = false;
var addBranchLaunch = false;
var cancelProfileEdit = true;
toastr.options.timeOut = 4000;
toastr.options.positionClass = 'toast-bottom-right';

var standalonePasswordReset = new PasswordReset("standalonePasswordReset");

var arrayUtils = {
    arrayForEach: function (array, action) {
        for (var i = 0, j = array.length; i < j; i++)
            action(array[i]);
    },

    arrayIndexOf: function (array, item) {
        if (typeof Array.prototype.indexOf == "function")
            return Array.prototype.indexOf.call(array, item);
        for (var i = 0, j = array.length; i < j; i++)
            if (array[i] === item)
                return i;
        return -1;
    },

    arrayFirst: function (array, predicate, predicateOwner) {
        for (var i = 0, j = array.length; i < j; i++)
            if (predicate.call(predicateOwner, array[i]))
                return array[i];
        return null;
    },

    arrayRemoveItem: function (array, itemToRemove) {
        var index = arrayUtils.arrayIndexOf(array, itemToRemove);
        if (index >= 0)
            array.splice(index, 1);
    },

    arrayGetDistinctValues: function (array) {
        array = array || [];
        var result = [];
        for (var i = 0, j = array.length; i < j; i++) {
            if (arrayUtils.arrayIndexOf(result, array[i]) < 0)
                result.push(array[i]);
        }
        return result;
    },

    arrayMap: function (array, mapping) {
        array = array || [];
        var result = [];
        for (var i = 0, j = array.length; i < j; i++)
            result.push(mapping(array[i]));
        return result;
    },

    arrayFilter: function (array, predicate) {
        array = array || [];
        var result = [];
        for (var i = 0, j = array.length; i < j; i++)
            if (predicate(array[i]))
                result.push(array[i]);
        return result;
    },

    arrayPushAll: function (array, valuesToPush) {
        for (var i = 0, j = valuesToPush.length; i < j; i++)
            array.push(valuesToPush[i]);
        return array;
    }
};

$(function () {
    WireupAddUserHandlers2();
    if (appraiserProfile !== undefined && appraiserProfile !== null) {
        setAppraiserProfileEvents();
        var noMobileNumber = isNullOrWhiteSpace($("#vmTxtMobilePhone").val());
        $("#vmOptInMessagesCheckBox").prop("disabled", noMobileNumber);
    }

    standalonePasswordReset.init();
});

function changeToUpperCaseProf() {
    key = window.event.keyCode;
    if ((key > 0x60) && (key < 0x7B))
        window.event.keyCode = key - 0x20;
}

function LogoutAlertProf() {
    bootbox.alert("Your password has been reset. Please log back in using your new password.", function () {
        window.location = '../Login/Login.aspx?action=logout';
    });
}

function WebLoginIdChangeAlertProf() {
    bootbox.alert("Password reset instructions have been sent to the email address on file. Please login after resetting the password.", function () {
        window.location = '../Login/Login.aspx?action=logout';
    });
}

function PermissionChangeAlertProf() {
    bootbox.alert("Your Permission has been updated. Please log back in again", function () {
        window.location = '../Login/Login.aspx?action=logout';
    });
}

function ConfirmDeleteProf(id) {
    bootbox.confirm({
        title: 'Please Confirm',
        message: 'Are you sure you want to delete user account of ' + id + '?',
        buttons: {
            'confirm': {
                label: '<i class="fa fa-check"></i>&nbsp;Yes',
                className: 'btn btn-primary btn-flat'
            },
            'cancel': {
                label: '<i class="fa fa-remove"></i>&nbsp;No',
                className: 'btn btn-default btn-flat'
            }
        },
        callback: function (result) {
            if (result) {
                var jsonText = $.toJSON({ contactId: um_hdnContactId, transactionId: $("#" + window.dm_ViewId).val() });
                ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/ConfirmDelete",
                    jsonText,
                    function (msg) {
                        msg = $.parseJSON(msg.d);
                        if (msg.Success !== true) {
                            ShowError(msg.Result);
                            return;
                        }
                        else
                            window.location.replace('AccountMaintenance.aspx');
                    });
            }
            return;
        }
    });
}

function setAppraiserProfileEvents() {
    appraiserProfile.UseDayLightSaving = appraiserProfile.UseDayLightSaving > 0;
    appraiserProfile.AutoAcceptOrder = appraiserProfile.AutoAcceptOrder > 0;
    appraiserProfile.OptInTextMessages = appraiserProfile.OptInTextMessages > 0;
    //
    $("#vmTxtLastName").on("change", function () {
        appraiserProfile.LastName = $(this).val();
        canSaveAppraiserProfile();
    });
    $("#vmTxtFirstName").on("change", function () {
        appraiserProfile.FirstName = $(this).val();
        canSaveAppraiserProfile();
    });
    $("#vmTxtEmail").on("change", function () {
        var email = $(this).val();
        if (!isValidEmail(email)) {
            $(this).addClass("errorHighligter");
        } else {
            $(this).removeClass("errorHighligter");
            appraiserProfile.Email = email;
        }
        canSaveAppraiserProfile();
    });
    $("#vmTxtPhone").on("change", function () {
        var phone = $(this).val();
        if (!isValidUsPhoneNumber(phone)) { phone = ""; }
        appraiserProfile.Phone1 = phone;
        canSaveAppraiserProfile();
    });
    $("#vmTxtMobilePhone").on("change", function () {
        var mobileNumber = $(this).val();
        if (isNullOrWhiteSpace(mobileNumber) || !isValidUsPhoneNumber(mobileNumber)) {
            mobileNumber = "";
            appraiserProfile.OptInTextMessages = false;
            $("#vmOptInMessagesCheckBox").prop('checked', false);
            $("#vmOptInMessagesCheckBox").prop("disabled", true);
        } else {
            $("#vmOptInMessagesCheckBox").prop("disabled", false);
        }
        appraiserProfile.Mobile = mobileNumber;
        canSaveAppraiserProfile();
    });
    $("#vmTxtAddress1").on("change", function () {
        var value = $(this).val();
        appraiserProfile.Line1 = value;
        appraiserProfile.Address1 = value;
        canSaveAppraiserProfile();
    });
    $("#vmTxtAddress2").on("change", function () {
        var value = $(this).val();
        appraiserProfile.Line2 = value;
        appraiserProfile.Address2 = value;
        canSaveAppraiserProfile();
    });
    $("#vmTxtCity").on("change", function () {
        appraiserProfile.City = $(this).val();
        canSaveAppraiserProfile();
    });
    $("#vmListState").on("change", function () {
        //$("#vmListState option:selected").val();//gives state code such as (OH)
        //$("#vmListState option:selected").text();//gives state name such as (Ohio)
        appraiserProfile.State = $(this).val();
        canSaveAppraiserProfile();
    });
    $("#vmTxtZip").on("change", function () {
        appraiserProfile.Zip = $(this).val();
        canSaveAppraiserProfile();
    });
    $("#vmLstTimeZone").on("change", function () {
        appraiserProfile.TimeZone = $(this).val();
        canSaveAppraiserProfile();
    });
    $("#vmAutoAcceptOrderCheckBox").on("change", function () {
        appraiserProfile.AutoAcceptOrder = $("#vmAutoAcceptOrderCheckBox").is(':checked');
        canSaveAppraiserProfile();
    });
    $("#vmOptInMessagesCheckBox").on("change", function () {
        appraiserProfile.OptInTextMessages = $("#vmOptInMessagesCheckBox").is(':checked');
        canSaveAppraiserProfile();
    });
    $("#vmUseDayLightSavingCheckBox").on("change", function () {
        appraiserProfile.UseDayLightSaving = $("#vmUseDayLightSavingCheckBox").is(':checked');
        canSaveAppraiserProfile();
    });
    //
    $('#EditProfile').on('hide.bs.modal', function () {
        updateFields();
    });
};

function updateFields() {
    var i, textFields, checkBoxes, options;
    //on cancel, revert any changes if any
    if (currentSuffix && currentSuffix === "VM" && cancelProfileEdit) {
        textFields = $("#appraiserProfile").find("input[type='text'],input[type='search']");
        for (i = 0; i < textFields.length; i++) {
            var textField = textFields[i];
            $(textField).val($(textField).prop("defaultValue"));
        }
        checkBoxes = $("#appraiserProfile").find("input[type='checkbox']");
        for (i = 0; i < textFields.length; i++) {
            var checkBox = checkBoxes[i];
            $(checkBox).prop("checked", $(checkBox).prop("defaultChecked"));
        }
        options = $("#appraiserProfile").find("option");
        for (i = 0; i < options.length; i++) {
            var option = options[i];
            if (!option.defaultSelected) continue;
            var val = $(option).val();
            var parentId = $(option).parent()[0].id;
            if (parentId === "vmListState") {
                $("#vmListState").val(val);
            }
            if (parentId === "vmLstTimeZone") {
                $("#vmLstTimeZone").val(val);
            }
        }
    }
    //on save, update default values
    if (currentSuffix && currentSuffix === "VM" && !cancelProfileEdit) {
        textFields = $("#appraiserProfile").find("input[type='text'],input[type='search']");
        for (i = 0; i < textFields.length; i++) {
            var textField = textFields[i];
            $(textField).prop("defaultValue", $(textField).val());
        }
        checkBoxes = $("#appraiserProfile").find("input[type='checkbox']");
        for (i = 0; i < textFields.length; i++) {
            var checkBox = checkBoxes[i];
            $(checkBox).prop("defaultChecked", $(checkBox).prop("checked"));
        }
        options = $("#appraiserProfile").find("option");
        for (i = 0; i < options.length; i++) {
            var option = options[i];
            if (option.defaultSelected && $(option).parent()[0].id === "vmLstTimeZone") {
                $(option).val($("#vmLstTimeZone").val());
                break;
            }
            //Code below Prior to 11-26-2018.  replaced with above code
            //Below code sets the State dropdown value to the value of the time zone (bug) - GG
            //if (option.defaultSelected) {
            //    $(option).val($("#vmLstTimeZone").val());
            //    break;
            //}
        }
    }
};

function canSaveAppraiserProfile() {
    var isInvalid = !isValidEmail($("#vmTxtEmail").val());
    isInvalid = isInvalid || isNullOrWhiteSpace($("#vmTxtFirstName").val());
    isInvalid = isInvalid || isNullOrWhiteSpace($("#vmTxtLastName").val());
    isInvalid = isInvalid || isNullOrWhiteSpace($("#vmTxtAddress1").val());
    isInvalid = isInvalid || isNullOrWhiteSpace($("#vmTxtCity").val());
    isInvalid = isInvalid || isNullOrWhiteSpace($("#vmListState").val());
    isInvalid = isInvalid || isNullOrWhiteSpace($("#vmTxtZip").val());

    $("#vmbtnSaveUser").prop("disabled", isInvalid);
};


function isCanvasBlank(canvas) {
    var blank = document.createElement('canvas');
    blank.width = canvas.width;
    blank.height = canvas.height;

    return canvas.toDataURL() == blank.toDataURL();
}

function SaveUser() {
    var jsonText;
    if (appraiserProfile && currentSuffix && currentSuffix === "VM") {

        var canvas = document.getElementById("canvas");

        if (canvas != null) {
            var blank = isCanvasBlank(canvas);

            if (!blank) {
                var dataURL = canvas.toDataURL("image/png");
                appraiserProfile.ImageString = dataURL;
                $.getElementByClientId("appraiserSignatureHighlight").trigger("change");
            }
        }
        cancelProfileEdit = false;
        jsonText = $.toJSON({
            contactInfo: appraiserProfile,
            transactionId: $("#" + window.dm_TransactionId).val()
        });
        ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/UpdateAppraiserMainProfile",
            jsonText,
            function (msg) {
                msg = $.parseJSON(msg.d);
                $("#" + window.dm_TransactionId).val(msg.TransactionId);
                if (msg.Success) {
                    if (!blank) {
                        $.getElementByClientId("appraiserSignatureHighlight").trigger("change");
                    };
                    $("#ctl00_userLogged").text(appraiserProfile.FirstName + " " + appraiserProfile.LastName);
                    Notify("Changes saved successfully.", "bottom-right", "5000", "success", "fa-check", true);
                    updateDefaultFieldValues();
                } else {
                    Notify("Could not save changes.", "bottom-right", "5000", "danger", "fa-times", true);
                }
                //
                $('#EditProfile').modal('hide');
            },
            function () {
                ShowError("Could not save changes.");
            });
    }
    else {
        var currentDate = new Date();
        var rowlocked = $("#ctl00_ucProfile_rowlockedout").is(":visible");
        var userlockedout = $("#ctl00_ucProfile_chklockedout").is(":checked");
        var branch;
        if ($("#ctl00_ucProfile_lstBranches option:selected").val() !== null && $("#ctl00_ucProfile_lstBranches option:selected").val() !== "") {
            branch = $("#ctl00_ucProfile_lstBranches option:selected").val();
        } else {
            branch = $("#ctl00_ucProfile_lstHomeOffice option:selected").val();
        }
        var userInformation;
        var permissionsObj = {
            BranchId: branch,
            LastModBy: user,
            UserId: user,
            ContactId: um_hdnContactId,
            OtOrderEntry: $("#ctl00_ucProfile_chkotOrderentry").is(':checked'),
            OtWorkQueues: $("#ctl00_ucProfile_chkotWorkQueues").is(':checked'),
            OtEditNote: $("#ctl00_ucProfile_chkotEditNote").is(':checked'),
            OtOrderSearch: $("#ctl00_ucProfile_chkotOrderSearch").is(':checked'),
            VmAutomatedAssignment: $("#ctl00_ucProfile_chkVMAutomatedAssignment").is(':checked'),
            VmVendorSearch: $("#ctl00_ucProfile_chkVmSearchByVendor").is(':checked'),
            VmSetVendorPreference: $("#ctl00_ucProfile_chkVMSetPreferenceByScore").is(':checked'),
            VmComplianceSummary: $("#ctl00_ucProfile_chkVMComplianceSummary").is(':checked'),
            VmAddVendor: $("#ctl00_ucProfile_chkVMAddNewVendor").is(':checked'),
            VmBrowseCoverage: $("#ctl00_ucProfile_chkVmBrowseByCoverage").is(':checked'),
            VmScoring: $("#ctl00_ucProfile_chkVMScoring").is(':checked'),
            AnDashboards: $("#ctl00_ucProfile_chkANDashboards").is(':checked'),
            AnReports: $("#ctl00_ucProfile_chkANReports").is(':checked'),
            CmClientSearch: $("#ctl00_ucProfile_chkCMclientSearch").is(':checked'),
            AdUserMaintenance: $("#ctl00_ucProfile_chkADUserMaintenance").is(':checked'),
            AdWorkQueues: $("#ctl00_ucProfile_chkADWorkQueues").is(':checked'),
            AdBusinessRules: $("#ctl00_ucProfile_chkADBusinessRules").is(':checked'),
            AdTeams: $("#ctl00_ucProfile_chkADTeams").is(':checked'),
            AdCascadeMaint: $("#ctl00_ucProfile_chkADCascadeMaint").is(':checked'),
            AdCascadeGroupMaint: $("#ctl00_ucProfile_chkADCascadeGroupMaint").is(':checked')
        }
        if (rowlocked && !userlockedout) {
            userInformation = {
                UserId: $("#ctl00_ucProfile_txtWebLogin").val().trim(),
                ContactId: um_hdnContactId,
                BranchId: $("#ctl00_ucProfile_lstHomeOffice option:selected").val(),
                FirstName: $("#ctl00_ucProfile_txtFirstName").val(),
                LastName: $("#ctl00_ucProfile_txtLastName").val(),
                Email: $("#ctl00_ucProfile_txtEmail").val(),
                QualifiedUserId: $("#ctl00_ucProfile_txtWebLogin").val(),
                LastModBy: user,
                LastModDate: currentDate,
                FullName: $("#ctl00_ucProfile_txtFirstName").val().trim() + " " + $("#ctl00_ucProfile_txtLastName").val().trim(),
                TimeZone: $("#ctl00_ucProfile_lstTimeZone option:selected").val(),
                IncorrectLoginAttempts: 0,
                UserLockedOut: false,
                LockedOutReason: null,
                LockoutExpiryDate: null,
                UseDayLightSaving: $("#ctl00_ucProfile_chkDaylight").is(':checked')
            };
        } else {
            userInformation = {
                UserId: $("#ctl00_ucProfile_txtWebLogin").val().trim(),
                ContactId: um_hdnContactId,
                BranchId: $("#ctl00_ucProfile_lstHomeOffice option:selected").val(),
                FirstName: $("#ctl00_ucProfile_txtFirstName").val(),
                LastName: $("#ctl00_ucProfile_txtLastName").val(),
                Email: $("#ctl00_ucProfile_txtEmail").val(),
                QualifiedUserId: $("#ctl00_ucProfile_txtWebLogin").val(),
                LastModBy: user,
                LastModDate: currentDate,
                FullName: $("#ctl00_ucProfile_txtFirstName").val().trim() + " " + $("#ctl00_ucProfile_txtLastName").val().trim(),
                TimeZone: $("#ctl00_ucProfile_lstTimeZone option:selected").val(),
                UseDayLightSaving: $("#ctl00_ucProfile_chkDaylight").is(':checked')
            };
        }
        jsonText = $.toJSON({
            user: userInformation,
            permissions: permissionsObj,
            transactionId: $("#" + window.dm_TransactionId).val()
        });
        ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/UpdateCollateralsProfile",
            jsonText,
            function (msg) {
                msg = $.parseJSON(msg.d);
                $("#" + window.dm_TransactionId).val(msg.TransactionId);
                if (msg.Success !== true) {
                    if (msg.ErrorMessage !== "") {
                        toastr.warning(msg.ErrorMessage);
                    } else {
                        toastr.warning('Error updating profile, please try again later.');
                    }
                }
                //document.cookie = "userTimeZone=" + userInformation.TimeZone + "; path=/";
                setCookie("userTimeZone", userInformation.TimeZone);
                // Force an update to the global User Time Zone so if the user changes it, it will show up instantaneously
                _userTimeZone = getUserSpecificTimeZoneById(parseInt(userInformation.TimeZone));
                $("#lastLoggedIn").html(formatAsUserSpecificDate(lastLoginDateSplit[0] + " " + lastLoginDateSplit[1] + " " + lastLoginDateSplit[2]));

                toastr.success('Changes saved successfully.');
                $("#ctl00_userLogged").text(userInformation.FirstName + " " + userInformation.LastName);
                //
                initialLstTimeZone = $("#ctl00_ucProfile_lstTimeZone option:selected").val();
                initialHomeOffice = $("#ctl00_ucProfile_lstHomeOffice option:selected").val();
                initialLstBranch = $("#ctl00_ucProfile_lstBranches option:selected").val();

                //
                $('.modal-backdrop').remove();
                $('#EditProfile').modal('hide');
            });
    }
};

function updateDefaultFieldValues() {
    if (typeof appraiserProfile == null) return;
    //
    $("#vmAutoAcceptOrderCheckBox").prop("defaultChecked", appraiserProfile.AutoAcceptOrder);
    $("#vmTxtEmail").prop("defaultValue", appraiserProfile.Email);
    $("#vmTxtFirstName").prop("defaultValue", appraiserProfile.FirstName);
    $("#vmTxtLastName").prop("defaultValue", appraiserProfile.LastName);
    $("#vmTxtAddress1").prop("defaultValue", appraiserProfile.Address1);
    $("#vmTxtAddress2").prop("defaultValue", appraiserProfile.Address2);
    $("#vmTxtCity").prop("defaultValue", appraiserProfile.City);
    $("#vmTxtZip").prop("defaultValue", appraiserProfile.Zip);
    $("#vmTxtPhone").prop("defaultValue", appraiserProfile.Phone1);
    $("#vmTxtMobilePhone").prop("defaultValue", appraiserProfile.Mobile);
    $("#vmOptInMessagesCheckBox").prop("defaultChecked", appraiserProfile.OptInTextMessages);
    $("#vmUseDayLightSavingCheckBox").prop("defaultChecked", appraiserProfile.UseDayLightSaving);

    var options = $("#appraiserProfile").find("option");
    $.each(options, function (index, option) {
        $(option).removeAttr("selected");
        var val = $(option).val();
        var parentId = $(option).parent()[0].id;
        if (parentId === "vmListState" && val === appraiserProfile.State) {
            $(option).attr("selected", "selected");
            $("#vmListState").val(appraiserProfile.State);
        }
        if (parentId === "vmLstTimeZone" && val === appraiserProfile.TimeZone.toString()) {
            $(option).attr("selected", "selected");
            $("#vmLstTimeZone").val(appraiserProfile.TimeZone);
        }
    });
};


function AddBranchProf() {
    var branchObj;
    var branchid;
    if ($("#ctl00_ucProfile_lstAddBranch option:selected").val() != null &&
        $("#ctl00_ucProfile_lstAddBranch option:selected").val() != "") {
        branchid = $("#ctl00_ucProfile_lstAddBranch option:selected").val();
        var desc = $("#ctl00_ucProfile_lstAddBranch option:selected").text();
        branchObj = {
            BranchId: branchid,
            UserId: user,
            ContactId: um_hdnContactId,
        };

        var jsonText = $.toJSON({
            branch: branchObj,
            transactionId: $("#" + window.dm_TransactionId).val()
        });
        ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/AddBranch",
            jsonText,
            function (msg) {
                msg = $.parseJSON(msg.d);
                $("#" + window.dm_TransactionId).val(msg.TransactionId);
                if (msg.Success !== true) {
                    toastr.warning('Error adding new branch, please try again later.');
                    return "";
                }

                $('#ctl00_ucProfile_lstBranches').append(new Option(desc, branchid, false, true));
                $('#ctl00_ucProfile_lstBranches').trigger('change');
                toastr.success('New branch added successfully.');
                return true;
            });
    } else {
        toastr.warning('Please select the branch to be added.');
    }
    CloseAddBranchProf();
}

function DeleteBranchProf() {
    if ($('#ctl00_ucProfile_lstBranches option').length == 1) {
        toastr.warning('Deleting the last branch requires the user to be deleted as well. Please delete the user');
        return "";
    }
    if ($("#ctl00_ucProfile_lstBranches option:selected").val() == null ||
        $("#ctl00_ucProfile_lstBranches option:selected").val() == "") {
        toastr.warning('Please select a value');
        return "";
    }
    var branch = $("#ctl00_ucProfile_lstBranches option:selected").val();
    var userInfo = {
        UserId: user,
        BranchId: branch,
        ContactId: um_hdnContactId
    };
    var jsonText = $.toJSON({
        user: userInfo,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/DeleteUserBranch",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                toastr.warning('Error deleting branch, please try again later.');
                return "";
            }

            $('#ctl00_ucProfile_lstBranches').find("option[value='" + branch + "']").remove();
            $('#ctl00_ucProfile_lstBranches option:first-child').attr("selected", "selected");
            $('#ctl00_ucProfile_lstBranches').trigger('change');
            toastr.success('Selected branch deleted successfully.');
            return true;
        });
    CloseDeleteBranchProf();
    return true;
}

function WireupAddUserHandlers2() {

    try {
        InitAddUser2();
    }
    catch (error) { }

    if (acc_btnPasswordChange == 0) {
        um_btnChangePass.hide();
        $("#lnkProfileSecurityQuestions").hide();
    }

    if (acc_btnPasswordChange) {
        um_btnChangePass.click(function () {
            $("#ctl00_ucProfile_lblPasswordError").html("");
            $("#divChangePassword").show('open');
            return false;
        });
    }

    if (acc_securityQuestionCount == 0)
        $("#lnkProfileSecurityQuestions").hide();

    $("#btnCancelPasswordChange1").on('click', function () {
        $("#divChangePassword").hide();
    });

    //
    $("#ctl00_ucProfile_lstHomeOffice").on('focus', function () {
        if (!initialHomeOffice) {
            initialHomeOffice = this.value;
            $("#ctl00_ucProfile_lstHomeOffice").off('focus');
        }
    }).change(function () {
        //var homeBranch = $("#ctl00_ucProfile_lstHomeOffice option:selected").val();
        //var selectedBranch = $("#ctl00_ucProfile_lstBranches option:selected").val();
    });

    //
    $("#ctl00_ucProfile_lstBranches").on('focus', function () {
        if (!initialLstBranch) {
            initialLstBranch = this.value;
            $("#ctl00_ucProfile_lstBranches").off('focus');
        }
    }).change(function () {
        //var homeBranch = $("#ctl00_ucProfile_lstHomeOffice option:selected").val();
        var selectedBranch = $("#ctl00_ucProfile_lstBranches option:selected").val();
        var weblogin = $("#ctl00_ucProfile_txtWebLogin").val();
        var jsonText = $.toJSON({ webloginId: weblogin, selectedBranch: selectedBranch === undefined || selectedBranch === null ? "" : selectedBranch, transactionId: $("#" + window.dm_ViewId).val() });
        ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/GetPermissions",
            jsonText,
            function (msg) {
                msg = $.parseJSON(msg.d);
                $("#" + window.dm_ViewId).val(msg.TransactionId);
                if (msg.Success !== true) {
                    ShowError(msg.Result);
                    return '';
                }
                //populate checkboxes
                //order tracking
                var selectAllChecked = false;
                $("#ctl00_ucProfile_chkotOrderentry").prop('checked', msg.Data.OtOrderEntry);
                selectAllChecked = msg.Data.OtOrderEntry;
                $("#ctl00_ucProfile_chkotWorkQueues").prop('checked', msg.Data.OtWorkQueues);
                selectAllChecked = selectAllChecked && msg.Data.OtWorkQueues;

                $("#ctl00_ucProfile_chkotEditNote").prop('checked', msg.Data.OtEditNote);
                selectAllChecked = selectAllChecked && msg.Data.OtEditNote;

                $("#ctl00_ucProfile_chkotOrderSearch").prop('checked', msg.Data.OtOrderSearch);
                selectAllChecked = selectAllChecked && msg.Data.OtOrderSearch;
                $('#chkProfOrderEntryAll').prop("checked", selectAllChecked);
                //client maintenance
                $("#ctl00_ucProfile_chkCMclientSearch").prop('checked', msg.Data.CmClientSearch);
                selectAllChecked = msg.Data.CmClientSearch;
                $('#chkprofclientMainSelectAll').prop("checked", selectAllChecked);
                //vendor maintenance
                $("#ctl00_ucProfile_chkVmSearchByVendor").prop('checked', msg.Data.VmVendorSearch);
                selectAllChecked = msg.Data.VmVendorSearch;
                $("#ctl00_ucProfile_chkVmBrowseByCoverage").prop('checked', msg.Data.VmBrowseCoverage);
                selectAllChecked = selectAllChecked && msg.Data.VmBrowseCoverage;
                $("#ctl00_ucProfile_chkVMAddNewVendor").prop('checked', msg.Data.VmAddVendor);
                selectAllChecked = selectAllChecked && msg.Data.VmAddVendor;
                $("#ctl00_ucProfile_chkVMSetPreferenceByScore").prop('checked', msg.Data.VmSetVendorPreference);
                selectAllChecked = selectAllChecked && msg.Data.VmSetVendorPreference;
                $("#ctl00_ucProfile_chkVMComplianceSummary").prop('checked', msg.Data.VmComplianceSummary);
                selectAllChecked = selectAllChecked && msg.Data.VmComplianceSummary;
                $("#ctl00_ucProfile_chkVMAutomatedAssignment").prop('checked', msg.Data.VmAutomatedAssignment);
                selectAllChecked = selectAllChecked && msg.Data.VmAutomatedAssignment;
                $("#ctl00_ucProfile_chkVMScoring").prop('checked', msg.Data.VmScoring);
                selectAllChecked = selectAllChecked && msg.Data.VmScoring;
                $('#chkProfVendorMaintenanceSelectAll').prop("checked", selectAllChecked);
                //analytics
                $("#ctl00_ucProfile_chkANReports").prop('checked', msg.Data.AnReports);
                selectAllChecked = msg.Data.AnReports;
                $("#ctl00_ucProfile_chkANDashboards").prop('checked', msg.Data.AnDashboards);
                selectAllChecked = selectAllChecked && msg.Data.AnDashboards;
                $('#chkProfANSelectAll').prop("checked", selectAllChecked);
                //administration
                $("#ctl00_ucProfile_chkADUserMaintenance").prop('checked', msg.Data.AdUserMaintenance);
                selectAllChecked = msg.Data.AdUserMaintenance;
                $("#ctl00_ucProfile_chkADWorkQueues").prop('checked', msg.Data.AdWorkQueues);
                selectAllChecked = selectAllChecked && msg.Data.AdWorkQueues;
                $("#ctl00_ucProfile_chkADBusinessRules").prop('checked', msg.Data.AdBusinessRules);
                selectAllChecked = selectAllChecked && msg.Data.AdBusinessRules;
                $("#ctl00_ucProfile_chkADTeams").prop('checked', msg.Data.AdTeams);
                selectAllChecked = selectAllChecked && msg.Data.AdTeams;
                $("#ctl00_ucProfile_chkADCascadeMaint").prop('checked', msg.Data.AdCascadeMaint);
                selectAllChecked = selectAllChecked && msg.Data.AdCascadeMaint;
                $("#ctl00_ucProfile_chkADCascadeGroupMaint").prop('checked', msg.Data.AdCascadeGroupMaint);
                selectAllChecked = selectAllChecked && msg.Data.AdCascadeGroupMaint;
                getDomElementById("chkADBranchTeams").prop("checked", selectAllChecked && msg.Data.AdBranchTeams);
                getDomElementById("chkOtCubiCasaAdvancedEditor").prop("checked", selectAllChecked && msg.Data.OtUseCubiCasaAdvancedEditor);
                getDomElementById("chkADMessageFolders").prop("checked", selectAllChecked && msg.Data.AdMessageFolders);
                getDomElementById("chkADMessageRules").prop("checked", selectAllChecked && msg.Data.AdMessageRules);
                getDomElementById("chkADComboMaint").prop("checked", selectAllChecked && msg.Data.AdComboMaint);

                $('#chkProfAdministrationSelectAll').prop("checked", selectAllChecked);
                if (currentSuffix && currentSuffix !== "VM") {
                    SelectGeneralTabProf();
                }
                $("#ctl00_ucProfile_deletingBranch").html(selectedBranch);
                return false;
            });

    });

    //
    $("#ctl00_ucProfile_lstTimeZone").on('focus', function () {
        if (!initialLstTimeZone) {
            initialLstTimeZone = this.value;
            $("#ctl00_ucProfile_lstTimeZone").off('focus');
        }
    }).change(function () {
    });

    //
    WireupSecurityQuestionReset2();

    if ($('.chkProfOrderEntry:checked').length == $('.chkProfOrderEntry').length) {
        $("#chkProfOrderEntryAll").prop('checked', true);
    }


    $('#EditProfile').on('show.bs.modal', function () {
        if (addBranchLaunch || deleteBranchLaunch) {
            addBranchLaunch = false;
            deleteBranchLaunch = false;
        } else {
            if (currentSuffix && currentSuffix === "VM") {
                canSaveAppraiserProfile();
            } else {
                SelectGeneralTabProf();
                SelectBranchControls(true);
            }
        }
    });

    $('#DeleteProfileModal').on('show.bs.modal', function () {
        addBranchLaunch = false;
        deleteBranchLaunch = true;
    });

    $('#AddProfileBranchModal').on('show.bs.modal', function () {
        addBranchLaunch = true;
        deleteBranchLaunch = false;
    });
}

function SelectGeneralTabProf() {
    //force general tab to be selected every time the form loads
    $('.nav-tabs a[href="#profile_general"]').tab('show');
}

function SelectBranchControls(resetPermissions) {

    var selectedHomeOffice = $('#ctl00_ucProfile_lstHomeOffice').val();
    if ((initialHomeOffice != null && initialHomeOffice != undefined) && (initialHomeOffice != selectedHomeOffice)) {
        $('#ctl00_ucProfile_lstHomeOffice').val(initialHomeOffice);
    }

    $('#ctl00_ucProfile_lstBranches').val($('#ctl00_ucProfile_lstHomeOffice').val());

    var selectedBranchHtml = $("#ctl00_ucProfile_lstBranches option:selected").val();
    $("#ctl00_ucProfile_deletingBranch").html(selectedBranchHtml);

    if (resetPermissions) {
        $('#ctl00_ucProfile_lstBranches').trigger('change');
    }

}

function WireupSecurityQuestionReset2() {
    if (acc_securityQuestionCount) {

        $("#lnkProfileSecurityQuestions").on('click', function () {
            $("#divSecurityQuestions tbody tr").remove();
            var html = parseTemplate($("#SecurityQuestionsTemplate").html(), { acc_securityQuestionCount: acc_securityQuestionCount });

            $(html).appendTo($("#divSecurityQuestions tbody"));

            if (acc_securityQuestions) {
                $(".cmbSecurityQuestion").empty().append("<option></option>");

                for (var i = 0; i < acc_securityQuestions.length; i++) {
                    $(".cmbSecurityQuestion").append($("<option/>").val(acc_securityQuestions[i].SecurityQuestionId).text(acc_securityQuestions[i].Question));
                }
            }
            $("#lblSecurityQuestionError").html("");

            $("#hdrSecurityQuestions").html("You are required to answer " + acc_securityQuestionCount + " questions.");
            $("#divSecurityQuestions").show('open');
            return false;

        });

        $("#btnSubmitSecurityQuestions").on('click', function () {

            var answers = [];
            var failed = false;
            var qualifiedId = um_qualifiedId;;

            $("#divSecurityQuestions tbody tr").each(function () {

                if (!failed) {
                    var id = $(this).find("select").val();
                    var qns = $(this).find("input").val();

                    if (!id || !qns) {
                        $("#lblSecurityQuestionError").html("Missing input.");
                        failed = true;
                    } else if (qns.length < 3) {
                        $("#lblSecurityQuestionError").html("Answers must be atleast 3 characters.");
                        failed = true;
                    } else {
                        answers.push({
                            SecurityQuestionId: id,
                            Answer: qns,
                            WebloginId: qualifiedId
                        });
                    }

                }

            });

            if (failed)
                return false;

            for (var i = 0; i < answers.length; i++) {
                var matches = arrayUtils.arrayFilter(answers, function (item) {
                    return item.SecurityQuestionId == answers[i].SecurityQuestionId;
                });

                if (matches.length > 1) {
                    $("#lblSecurityQuestionError").html("Same question cannot be selected multiple times.");
                    return false;
                }
            }
            var jsonText = $.toJSON({
                securityQuestions: answers,
                transactionId: $("#" + window.dm_TransactionId).val()
            });

            $.ajax({
                type: "POST",
                url: "../../WebServices/DataAccessServiceJson.asmx/SaveUserSecurityQuestions",
                data: jsonText,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (msg) {
                    msg = $.parseJSON(msg.d);
                    $("#" + window.dm_TransactionId).val(msg.TransactionId);
                    if (msg.Success !== true) {
                        $("#lblSecurityQuestionError").html(msg.ErrorMessage);
                    } else {
                        toastr.success("Changes saved successfully.");
                    }
                },
                error: function (data) {
                    msg = $.parseJSON(data.d);
                    $("#" + window.dm_TransactionId).val(msg.TransactionId);
                    toastr.error(msg.Result);
                }
            });
            $("#divSecurityQuestions").hide();
            return false;
        });

        $("#btnCancelSecurityQuestions1").on('click', function () {
            $("#divSecurityQuestions").hide();
            return false;
        });

    } else
        $("#lnkProfileSecurityQuestions").hide();
}

function UpdatePasswordProf() {

    var pass1 = um_passwordtxt.val();
    var pass2 = um_passwordConfrmtxt.val();
    var passOld = um_currentPasswordtxt.val();

    if (pass1.length < 8) {
        toastr.error("New password must be 8 characters or longer and cannot be blank.");
        return false;
    }
    if (pass1 != pass2) {
        toastr.error("Password doesn't match with retyped password.");
        return false;
    }

    var jsonText = $.toJSON({
        oldpw: passOld,
        newpw: pass1,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/UpdatePassword",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (!msg.Success) {
                toastr.error(msg.ErrorMessage);
            } else {
                LogoutAlertProf();
                return true;
            }
            return true;
        });
    return true;
}

function ClientValidateEmailProf(source, arguments) {

    arguments.IsValid = um_hdnEmails.val().indexOf(um_email.val()) < 0;
}

function OrderEntrySelectAllProf() {
    $(".chkProfOrderEntry").prop('checked', $("#chkProfOrderEntryAll").prop('checked'));
}

function ClientMainSelectAllProf() {
    $(".chkprofclientMain").prop('checked', $("#chkprofclientMainSelectAll").prop('checked'));
}

function AnalyticsSelectAllProf() {
    $(".chkProfAnalytics").prop('checked', $("#chkProfANSelectAll").prop('checked'));
}

function VendorMainSelectAllProf() {
    $(".chkProfVendorMain").prop('checked', $("#chkProfVendorMaintenanceSelectAll").prop('checked'));
}

function AdministrationSelectAllProf() {
    $(".chkprofadministration").prop('checked', $("#chkProfAdministrationSelectAll").prop('checked'));
}

function generalTabClickProf() {
    if ($('.chkProfOrderEntry:checked').length === $('.chkProfOrderEntry').length) {
        $("#chkProfOrderEntryAll").prop('checked', true);
    }
}

$(document).on('click', '.chkProfOrderEntry', function () {
    if ($('.chkProfOrderEntry:checked').length === $('.chkProfOrderEntry').length) {
        $("#chkProfOrderEntryAll").prop('checked', true);
    }
    else {
        $("#chkProfOrderEntryAll").prop('checked', false);
    }
});

function ClientMainTabClickProf() {
    if ($('.chkprofclientMain:checked').length == $('.chkprofclientMain').length) {
        $("#chkprofclientMainSelectAll").prop('checked', true);
    }
}

$(document).on('click', '.chkprofclientMain', function () {
    if ($('.chkprofclientMain:checked').length == $('.chkprofclientMain').length) {
        $("#chkprofclientMainSelectAll").prop('checked', true);
    }
    else {
        $("#chkprofclientMainSelectAll").prop('checked', false);
    }
});

function VenorMainTabClickProf() {
    if ($('.chkProfVendorMain:checked').length == $('.chkProfVendorMain').length) {
        $("#chkProfVendorMaintenanceSelectAll").prop('checked', true);
    }
}

$(document).on('click', '.chkProfVendorMain', function () {
    if ($('.chkProfVendorMain:checked').length == $('.chkProfVendorMain').length) {
        $("#chkProfVendorMaintenanceSelectAll").prop('checked', true);
    }
    else {
        $("#chkProfVendorMaintenanceSelectAll").prop('checked', false);
    }
});

function vendorTabClickProf() {
    if ($('.chkProfAnalytics:checked').length == $('.chkProfAnalytics').length) {
        $("#chkProfANSelectAll").prop('checked', true);
    }
}

function AdmisitrationTabClickProf() {
    try {
        if ($('.chkprofadministration:checked').length == $('.chkprofadministration').length) {
            $("#chkProfAdministrationSelectAll").prop('checked', true);
        }
    } catch (e) {
    }
}

$(document).on('click', '.chkprofadministration', function () {
    if ($('.chkprofadministration:checked').length == $('.chkprofadministration').length) {
        $("#chkProfAdministrationSelectAll").prop('checked', true);
    }
    else {
        $("#chkProfAdministrationSelectAll").prop('checked', false);
    }
});

$(document).on('click', '.chkProfAnalytics', function () {
    if ($('.chkProfAnalytics:checked').length == $('.chkProfAnalytics').length) {
        $("#chkProfANSelectAll").prop('checked', true);
    }
    else {
        $("#chkProfANSelectAll").prop('checked', false);
    }
});

function CloseAddBranchProf() {
    $('.modal-backdrop').remove();
    $('#AddProfileBranchModal').modal('hide');
}

function CloseDeleteBranchProf() {
    $('.modal-backdrop').remove();
    $('#DeleteProfileModal').modal('hide');
}

function VisibleTabsProf() {
    var homeBranch = $("#ctl00_ucProfile_lstHomeOffice option:selected").val();
    var selectedBranch = $("#ctl00_ucProfile_lstBranches option:selected").val();
}

function cancelUserProfileEdit() {
    if (currentSuffix && currentSuffix === "VM") {
        cancelProfileEdit = true;
        $('#EditProfile').modal('hide');
        return;
    }

    $('#ctl00_ucProfile_txtEmail').val($("#ctl00_ucProfile_txtEmail").prop("defaultValue"));
    $('#ctl00_ucProfile_txtFirstName').val($("#ctl00_ucProfile_txtFirstName").prop("defaultValue"));
    $('#ctl00_ucProfile_txtLastName').val($("#ctl00_ucProfile_txtLastName").prop("defaultValue"));
    $('#ctl00_ucProfile_chkDaylight').prop("checked", $("#ctl00_ucProfile_chkDaylight").prop("defaultChecked"));

    resetTabSectionCheckBoxes();

    //
    if (initialHomeOffice) {
        $('#ctl00_ucProfile_lstHomeOffice').val(initialHomeOffice);
    }
    if (initialLstBranch) {
        $('#ctl00_ucProfile_lstBranches').val(initialLstBranch);

    }
    if (initialLstTimeZone) {
        $('#ctl00_ucProfile_lstTimeZone').val(initialLstTimeZone);
    }
    //
    $('#EditProfile').modal('hide');
}

function resetTabSectionCheckBoxes() {
    //Order Tracking
    var defaultChecked = $('#ctl00_ucProfile_chkotOrderentry').prop("defaultChecked");
    $('#ctl00_ucProfile_chkotOrderentry').prop("checked", defaultChecked);
    var selectAllChecked = defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkotOrderSearch').prop("defaultChecked");
    $('#ctl00_ucProfile_chkotOrderSearch').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkotWorkQueues').prop("defaultChecked");
    $('#ctl00_ucProfile_chkotWorkQueues').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;

    defaultChecked = $('#ctl00_ucProfile_chkotEditNote').prop("defaultChecked");
    $('#ctl00_ucProfile_chkotEditNote').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;

    $('#chkProfOrderEntryAll').prop("checked", selectAllChecked);
    //Client Maintenance
    defaultChecked = $('#ctl00_ucProfile_chkCMclientSearch').prop("defaultChecked");
    $('#ctl00_ucProfile_chkCMclientSearch').prop("checked", defaultChecked);
    selectAllChecked = defaultChecked;
    $('#chkprofclientMainSelectAll').prop("checked", selectAllChecked);
    //Vendor Maintenance
    defaultChecked = $('#ctl00_ucProfile_chkVmSearchByVendor').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVmSearchByVendor').prop("checked", defaultChecked);
    selectAllChecked = defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkVmBrowseByCoverage').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVmBrowseByCoverage').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkVMAddNewVendor').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVMAddNewVendor').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkVMSetPreferenceByScore').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVMSetPreferenceByScore').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkVMComplianceSummary').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVMComplianceSummary').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkVMAutomatedAssignment').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVMAutomatedAssignment').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkVMScoring').prop("defaultChecked");
    $('#ctl00_ucProfile_chkVMScoring').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    $('#chkProfVendorMaintenanceSelectAll').prop("checked", selectAllChecked);
    //Analytics
    defaultChecked = $('#ctl00_ucProfile_chkANReports').prop("defaultChecked");
    selectAllChecked = defaultChecked;
    $('#ctl00_ucProfile_chkANReports').prop("checked", defaultChecked);
    defaultChecked = $('#ctl00_ucProfile_chkANDashboards').prop("defaultChecked");
    $('#ctl00_ucProfile_chkANDashboards').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    $('#chkProfANSelectAll').prop("checked", selectAllChecked);
    //Administration
    defaultChecked = $('#ctl00_ucProfile_chkADUserMaintenance').prop("defaultChecked");
    $('#ctl00_ucProfile_chkADUserMaintenance').prop("checked", defaultChecked);
    selectAllChecked = defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkADWorkQueues').prop("defaultChecked");
    $('#ctl00_ucProfile_chkADWorkQueues').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkADBusinessRules').prop("defaultChecked");
    $('#ctl00_ucProfile_chkADBusinessRules').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkADTeams').prop("defaultChecked");
    $('#ctl00_ucProfile_chkADTeams').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkADCascadeMaint').prop("defaultChecked");
    $('#ctl00_ucProfile_chkADCascadeMaint').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    defaultChecked = $('#ctl00_ucProfile_chkADCascadeGroupMaint').prop("defaultChecked");
    $('#ctl00_ucProfile_chkADCascadeGroupMaint').prop("checked", defaultChecked);
    selectAllChecked = selectAllChecked && defaultChecked;
    $('#chkProfAdministrationSelectAll').prop("checked", selectAllChecked);

    //select general by default
    if (currentSuffix && currentSuffix !== "VM") {
        SelectGeneralTabProf();
    }
    SelectBranchControls(false);
}


