﻿// Checks the status of the user authentication and if they lose authentication redirect to default login page.

$(function () {
    var refreshSession = (60 * 60000) + 1000; // (int * millsecond for min) + 1 (extra sec)
    window.setTimeout(sessionStatus, refreshSession);

    function sessionStatus() {
        $.ajax({
            type: "POST",
            url: "../../WebServices/DataAccessService.asmx/SessionAuthenticated",  
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (msg) {

                if (msg.d.Authenticated) {
                    window.setTimeout(sessionStatus, refreshSession);
                } else
                {
                    var page = window.location.toString();
                    if (page.toLowerCase().indexOf("login.aspx") === -1 && page.toLowerCase().indexOf("default.aspx") === -1) {
                        window.location = "../../Site/Login/Login.aspx?timeout=true&js=true";
                    }
                }

            },
            error: function (data) {

                alert(data.d.Result);
                window.location = "../../Site/Login/Login.aspx?timeout=true&js=true&err=true";
            }
        });
    }
}); 

// Global method call for any script to force a refresh if authentication is lost.
function SessionStatus() {
    $.ajax({
        type: "POST",
        url: "../../WebServices/DataAccessService.asmx/SessionAuthenticated",
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (msg) {

            if (!msg.d.Authenticated) {
                var page = window.location.toString();
                if (page.toLowerCase().indexOf("login.aspx") === -1 && page.toLowerCase().indexOf("default.aspx") === -1) {
                    window.location = "../../Site/Login/Login.aspx?timeout=true&js=true";
                }
            }
        },
        error: function (data) {

            alert(data.d.Result);
            window.location = "~/Site/Login/Login.aspx?timeout=true&js=true&err=true";
        }
    });
}