﻿// DataCollectorDashboard.js
var StartDate;
var EndDate;
var OUT_OF_OFFICE_MSG = "Out of Office enabled by vendor";
var OptionSelected = "";
var VendorId = "";
var _pageLength20 = 20;
$(document).ready(function () {
    InitMaster();
    loadDashboard(false);
    $('[data-toggle="tooltip"]').tooltip();
    $('#startDate').datetimepicker({
        format: 'MM/DD/YYYY',
        widgetPositioning: {
            vertical: "top"
        }
    });
    $('#endDate').datetimepicker({
        maxDate: moment().clone().add(180, "days"),
        format: 'MM/DD/YYYY',
        widgetPositioning: {
            vertical: "top"
        }
    });
    $("#editOOOSettings").tooltip();
    VendorId = $("#" + $$("hdnVendorId").attr("id")).val();

    $(window).bind('resize', function () {
        $('#dataTableOverdueOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableNewOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableInspectedOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableDueOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableGrabItBoard').dataTable().fnAdjustColumnSizing();
    });

    $('.widget-buttons *[data-toggle="collapse"]').on("click", function (event) {
        event.preventDefault();
        $('#dataTableOverdueOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableNewOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableInspectedOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableDueOrders').dataTable().fnAdjustColumnSizing();
        $('#dataTableGrabItBoard').dataTable().fnAdjustColumnSizing();
    });

    if (currentSuffix && currentSuffix === "VM") {
        loadVendorUsersMessages(false);
        registerVendorUsersEvents();
    }
});

function loadDashboard(updateSideBadgeCount) {
    //if (updateSideBadgeCount) {
    //    LoadVendorWorkQueueCounts();
    //    LoadVendorBatchWorkQueueCounts();
    //}
    //Get table data
    var jsonText = $.toJSON({
        transactionId: $("#" + window.dm_ViewId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/LoadVNDashboard",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_ViewId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.Result);
                return false;
            }

            var newOrders = [];
            var allInProcessOrders = [];
            var inProcessOrders = [];
            var inProcessBatchOrders = [];
            var ordersPastDue = [];
            var ordersDueToday = [];
            var inspectedOrders = [];
            var grabItBoardOrders = [];
            var now = moment().format("MM/DD/YYYY");

            if (msg.Data !== null) {
                newOrders          = exists(msg.Data.ResultSet) ? msg.Data.ResultSet : [];
                allInProcessOrders = exists(msg.Data.ResultSet2) ? msg.Data.ResultSet2 : [];
                grabItBoardOrders  = exists(msg.Data.ResultSet4) ? msg.Data.ResultSet4 : [];
            }
            var qcCorrectionFilterString = "Appraisal QC correction requested";
            if (allInProcessOrders.any()) {
                inProcessOrders = allInProcessOrders.where(function (x) { return exists(x) && !x.BatchClient && x.OrderStatus != qcCorrectionFilterString; });
                inProcessBatchOrders = allInProcessOrders.where(function (x) { return exists(x) && x.BatchClient && x.OrderStatus != qcCorrectionFilterString; });
                revisionOrders = allInProcessOrders.where(function (x) { return exists(x) && !x.BatchClient && x.OrderStatus == qcCorrectionFilterString; });
                revisionBatchOrders = allInProcessOrders.where(function (x) { return exists(x) && x.BatchClient && x.OrderStatus == qcCorrectionFilterString; });
                $("#" + $$("lblInProcessOrdersBadgeCount").attr("id")).text(inProcessOrders.length);
                //$("#" + $$("lblDCInProcessOrdersBadgeCount").attr("id")).text(inProcessOrders.length);
                $("#" + $$("lblInProcessBatchOrderBadgeCount").attr("id")).text(inProcessBatchOrders.length);
                $("#" + $$("lblRevisionBadgeCount").attr("id")).text(revisionOrders.length);
                $("#" + $$("lblRevisionBatchOrderBadgeCount").attr("id")).text(revisionBatchOrders.length);
            }
            $.each(allInProcessOrders, function (index, item) {
                var momento = moment(moment(item.AppDueDate, "MM/DD/YYYY").format("MM/DD/YYYY"),"MM/DD/YYYY");
                var isDueToday = momento.isSame(moment(now, "MM/DD/YYYY"));
                var isPastDue = momento.isBefore(moment(now, "MM/DD/YYYY"));
                var inspectionCompleted = item.InspectionStatus === "Completed";
                var inspectionNotApplicable = item.ProductCode === "A255" ? item.InspectionStatus === "N/A" : false;
                if (isPastDue) {
                    ordersPastDue.push(item);
                }
                if (isDueToday) {
                    ordersDueToday.push(item);
                }
                if (inspectionCompleted || inspectionNotApplicable) {
                    inspectedOrders.push(item);
                }
            });

            // For each widget, load the data into each table. If there is no data, collapse the individual widget to save space
            if (newOrders.length > 0) {
                loadNewOrdersTable(newOrders);
            } else {
                InitializeEmptyNewOrders();
            }
            $("#newOrderCount").text(newOrders.length);
            //
            if (ordersDueToday.length > 0) {
                loadDueOrdersTable(ordersDueToday);
            } else {
                InitializeEmptyDueOrders();
            }
            $("#ordersDueTodayCount").text(ordersDueToday.length);
            //
            if (ordersPastDue.length > 0) {
                loadOverdueOrdersTable(ordersPastDue);
            } else {
                InitializeEmptyOverdueOrders();
            }
            $("#ordersPastDueCount").text(ordersPastDue.length);
            //
            if (inspectedOrders.length > 0) {
                loadInspectedOrdersTable(inspectedOrders);
            } else {
                InitializeEmptyInspectedOrders();
            }
            $("#ordersInspectedCount").text(inspectedOrders.length);
            //
            if (grabItBoardOrders.length > 0) {
                loadGrabItBoardOrdersTable(grabItBoardOrders);
            } else {
                InitializeEmptyGrabItBoardOrders();
            }
            $("#grabItBoardOrderCount").text(grabItBoardOrders.length);
            return true;
        });
};

// EMPTY GRIDS
function InitializeEmptyNewOrders() {
    $('#dataTableNewOrders').DataTable().clear().draw();
    $('#dataTableNewOrders').dataTable().fnDestroy();
    $('#dataTableNewOrders')
        .DataTable({
            responsive: true,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, true);
            },
            aoColumnDefs: [
                { targets: 0, sClass: "width-100 td-align-m", 'bSortable': false },
                { targets: 1, sClass: "width-100 td-align-m" },
                { targets: 2, sClass: "width-40 td-align-m" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-110" },
                { targets: 5, sClass: "width-200" },
                { targets: 6, sClass: "width-130" },
                { targets: 7, sClass: "width-80" }
            ]
        });
}

function InitializeEmptyGrabItBoardOrders() {
    $('#dataTableGrabItBoard').DataTable().clear().draw();
    $('#dataTableGrabItBoard').dataTable().fnDestroy();
    $('#dataTableGrabItBoard')
        .DataTable({
            responsive: true,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, true);
            },
            aoColumnDefs: [
                { targets: 0, sClass: "width-50 td-align-m", 'bSortable': false },
                { targets: 1, sClass: "width-100 td-align-m" },
                { targets: 2, sClass: "width-40 td-align-m" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-110" },
                { targets: 5, sClass: "width-200" },
                { targets: 6, sClass: "width-130" },
                { targets: 7, sClass: "width-80" }
            ]
        });
}

function InitializeEmptyDueOrders() {
    $('#dataTableDueOrders').DataTable().clear().draw();
    $('#dataTableDueOrders').dataTable().fnDestroy();
    $('#dataTableDueOrders')
        .DataTable({
            responsive: true,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, true);
            },
            columnDefs: [
                { targets: 0, sClass: "width-100 td-align-m" },
                { targets: 1, sClass: "width-40 td-align-m" },
                { targets: 2, sClass: "width-110" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-200" },
                { targets: 5, sClass: "width-130" },
                { targets: 6, sClass: "width-80" },
                { targets: 7, sClass: "width-130", "visible": false },
                { targets: "_all", "defaultContent": "" }
            ]
        });
}

function InitializeEmptyOverdueOrders() {
    $('#dataTableOverdueOrders').DataTable().clear().draw();
    $('#dataTableOverdueOrders').dataTable().fnDestroy();
    $('#dataTableOverdueOrders').DataTable({
            responsive: true,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, true);
            },
            columnDefs: [
                { targets: 0, sClass: "width-100 td-align-m" },
                { targets: 1, sClass: "width-40 td-align-m" },
                { targets: 2, sClass: "width-110" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-200" },
                { targets: 5, sClass: "width-130" },
                { targets: 6, sClass: "width-80" },
                { targets: 7, sClass: "width-130", "visible": false },
                { targets: "_all", "defaultContent": "" }
            ]
        });
}

function InitializeEmptyInspectedOrders() {
    $('#dataTableInspectedOrders').DataTable().clear().draw();
    $('#dataTableInspectedOrders').dataTable().fnDestroy();
    $('#dataTableInspectedOrders')
        .DataTable({
            responsive: true,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, true);
            },
            aoColumnDefs: [
                { targets: 0, sClass: "width-100 td-align-m" },
                { targets: 1, sClass: "width-40 td-align-m" },
                { targets: 2, sClass: "width-110" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-200" },
                { targets: 5, sClass: "width-130" },
                { targets: 6, sClass: "width-80" },
                { targets: 7, sClass: "width-130" },
                { targets: "_all", "defaultContent": "" }
            ]
        });
}
// END EMPTY GRIDS

function AcceptOrder(rowId, orderNo, itemNo) {
    $('[data-toggle="tooltip"]').tooltip("hide");
    var jsonText = $.toJSON({
        rowId: rowId,
        orderNo: orderNo,
        itemNo: itemNo,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/AcceptOrder",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.Result);
                return '';
            }

            loadDashboard(true);
            loadOrdersByVendorId();
            loadDashboardBadges();

            return true;
        });
}

function AcceptGrabItOffer(orderNo, itemNo) {
    $('[data-toggle="tooltip"]').tooltip("hide");
    var jsonText = $.toJSON({
        vendorId: VendorId,
        orderNo: orderNo,
        itemNo: itemNo,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/AcceptGrabItBoardOffer",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.ErrorMessage);
            }

            loadDashboard(true);
            loadOrdersByVendorId();
            loadDashboardBadges();

            return true;
        });
}


function LoadRejectMoal(rowId, orderNo, itemNo) {
    $('[data-toggle="tooltip"]').tooltip("hide");
    $("#divRejectReason").modal('show');
    $("#hdnrowid").val(rowId);
    $("#hdnorderno").val(orderNo);
    $("#hdnitemno").val(itemNo);
    $("#lblreasonvalidation").hide();
    $("#lblAdditionalInforvalidation").hide();
    $("#" + $$("ddRejectReason").attr("id")).val("");
    $("#" + $$("txtRejectAdditionalInfo").attr("id")).val("");

}

function HideRejectModal() {
    $(".modal-backdrop").hide();
    $("#divRejectReason").modal('hide');
}

function Reject() {

    var reason = $("#" + $$("ddRejectReason").attr("id")).val();
    var additional = $("#" + $$("txtRejectAdditionalInfo").attr("id")).val();
    if (reason === "") {
        $("#lblreasonvalidation").show();
        
    }
    else if (additional === "") {
        $("#lblAdditionalInforvalidation").show();
        
        }
     else {
        RejectOrder();
    }
}

function RejectOrder() {
    var rowid = $("#hdnrowid").val();
    var ordernumber = $("#hdnorderno").val();
    var itemnumber = $("#hdnitemno").val();
    var rejectreason = $("#" + $$("ddRejectReason").attr("id")).val();
    var rejectReasonAdditionalInfo = $("#" + $$("txtRejectAdditionalInfo").attr("id")).val();

    $(".modal-backdrop").hide();
    $("#divRejectReason").modal('hide');

    var jsonText = $.toJSON({
        rowId: rowid,
        orderno: ordernumber,
        itemno: itemnumber,
        rejectreason: rejectreason,
        rejectreasonAdditionalInfo: rejectReasonAdditionalInfo,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/RejectOrder",
        jsonText,   
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.Result);
                return '';
            }
            loadDashboard(true);
            loadOrdersByVendorId();
            loadDashboardBadges();

            return true;

        });
}

// FULL GRIDS
function loadNewOrdersTable(results) {
    var resultsArray = [];

    for (var i = 0; i < results.length; i++) {
        var actions = '<a class="btn-xs" style="color: #049120; cursor: pointer" data-toggle="tooltip" data-container="body" id="lnkAcceptOrder" title="Accept Order" href="#" onclick="javascript:AcceptOrder(' + results[i].RowId +
            ',' + results[i].OrderNo + ',' + results[i].ItemNo + ')"><i class="fa fa-check-square-o"></i></a>&nbsp;' +
            '<a class="btn-xs" style="color: #FFCD01; visibility:hidden; cursor: pointer" data-toggle="tooltip" data-container="body" id="lnkConditionalAcceptance" title="Conditional Acceptance" href="#" onclick="javascript:loadConditionalAcceptanceModal(' + results[i].RowId +
            ',' + results[i].OrderNo + ',' + results[i].ItemNo + ')"><i class="fa fa-check-circle"></i></a>' +
            '<a class="btn-xs" data-toggle="tooltip" data-container="body" style="color: #CC1714; cursor: pointer" id="lnkRejectOrder" title="Reject Order" onclick="javascript:LoadRejectMoal(' +
            results[i].RowId + ',' + results[i].OrderNo + ',' + results[i].ItemNo + ')" href="#"><i class="fa fa-times"></i></a>';

        var delayed = results[i].Delayed ? getOnHoldIndicatorIcon() : "";

        var url = "OrderStatus.aspx?on=" + results[i].OrderNo + "&it=" + results[i].ItemNo + "&rs=1";
        var orderNo = "<a style='cursor:pointer;' onclick='window.open(\"" + url + "\",\"_blank\");'>" + results[i].OrderNo + "</a>";

        var priority = "";

        if (results[i].HighValue === true) {
            priority = "<i id=\"iconPriority\" class=\"fa fa-exclamation-triangle\" title=\"Priority\" style=\"color: red; cursor: help;\" data-placement=\"right\" data-toggle=\"tooltip\"></i>";
        }

        resultsArray.push([
            actions,
            priority,
            delayed,
            formatAsUserSpecificDate(results[i].EnteredDate),
            formatAsUserSpecificDate(results[i].DueDate),
            results[i].FullAddress,
            results[i].Product,
            orderNo
        ]);
    }

    $('#dataTableNewOrders').dataTable().fnDestroy();
    $('#dataTableNewOrders').DataTable({
        responsive: true,
        data: resultsArray,
        autoWidth: false,
        scrollY: "150px",
        scrollCollapse: true,
        scroller: true,
        sScrollX: "100%",
        pageLength: _pageLength20,
        lengthChange: false,
        stateSave: false,
        bFilter: false,
        aaSorting: [],
        fnInitComplete: function () {
            turnOffAutoComplete(this);
        },
        drawCallback: function (settings) {
            updateDataTablePagination(this, resultsArray.length <= 1);
            $('.dataTables_scrollBody').scrollTop(0);
        },
        aoColumnDefs: [
            { targets: 0, sClass:"width-100 td-align-m",'bSortable': false },
            { targets: 1, sClass:"width-100 td-align-m" },
            { targets: 2, sClass:"width-40 td-align-m" },
            { targets: 3,sClass:"width-110" },
            { targets: 4,sClass:"width-110" },
            { targets: 5,sClass:"width-200" },
            { targets: 6,sClass:"width-130" },
            { targets: 7, sClass: "width-80" },
            { targets: "_all", "defaultContent": "" }
        ]
    });

    $('#dataTableNewOrders').dataTable().fnPageChange(0);

}

function loadGrabItBoardOrdersTable(results) {
    var resultsArray = [];

    for (var i = 0; i < results.length; i++) {
        var actions = '<a class="btn-xs" style="color: #049120; cursor: pointer" data-toggle="tooltip" data-container="body" id="lnkAcceptOrder" title="Accept Offer" href="#" onclick="javascript:AcceptGrabItOffer(' +
                        results[i].OrderNo + ',' + results[i].ItemNo + ')"><i class="fa fa-check-square-o"></i></a>';

        var delayed = results[i].Delayed ? getOnHoldIndicatorIcon() : "";

        var url = "OrderStatus.aspx?on=" + results[i].OrderNo + "&it=" + results[i].ItemNo + "&rs=1";
        var orderNo = "<a style='cursor:pointer;' onclick='window.open(\"" + url + "\",\"_blank\");'>" + results[i].OrderNo + "</a>";

        var priority = "";

        if (results[i].HighValue === true) {
            priority = "<i id=\"iconPriority\" class=\"fa fa-exclamation-triangle\" title=\"Priority\" style=\"color: red; cursor: help;\" data-placement=\"right\" data-toggle=\"tooltip\"></i>";
        }

        resultsArray.push([
            actions,
            priority,
            delayed,
            formatAsUserSpecificDate(results[i].EnteredDate),
            formatAsUserSpecificDate(results[i].DueDate),
            results[i].FullAddress,
            results[i].Product,
            orderNo
        ]);
    }

    $('#dataTableGrabItBoard').dataTable().fnDestroy();
    $('#dataTableGrabItBoard').DataTable({
        responsive: true,
        data: resultsArray,
        autoWidth: false,
        scrollY: "150px",
        scrollCollapse: true,
        scroller: true,
        sScrollX: "100%",
        pageLength: _pageLength20,
        lengthChange: false,
        stateSave: false,
        bFilter: false,
        aaSorting: [],
        fnInitComplete: function () {
            turnOffAutoComplete(this);
        },
        drawCallback: function (settings) {
            updateDataTablePagination(this, resultsArray.length <= 1);
            $('.dataTables_scrollBody').scrollTop(0);
        },
        aoColumnDefs: [
            { targets: 0, sClass: "width-50 td-align-m", 'bSortable': false },
            { targets: 1, sClass: "width-100 td-align-m" },
            { targets: 2, sClass: "width-40 td-align-m" },
            { targets: 3, sClass: "width-110" },
            { targets: 4, sClass: "width-110" },
            { targets: 5, sClass: "width-200" },
            { targets: 6, sClass: "width-130" },
            { targets: 7, sClass: "width-80" },
            { targets: "_all", "defaultContent": "" }
        ]
    });

    $('#dataTableGrabItBoard').dataTable().fnPageChange(0);
}

function loadOverdueOrdersTable(results) {
    var resultsArray = [];

    for (var i = 0; i < results.length; i++) {

        var url = "OrderStatus.aspx?on=" + results[i].OrderNo + "&it=" + results[i].ItemNo + "&rs=1";
        var orderNo = "<a style='cursor:pointer;' onclick='window.open(\"" + url + "\",\"_blank\");'>" + results[i].OrderNo + "</a>";
        var priority = "";
        var delayed = results[i].Delayed ? getOnHoldIndicatorIcon() : "";

        if (results[i].HighValue === true) {
            priority = "<i id=\"iconPriority\" class=\"fa fa-exclamation-triangle\" title=\"Priority\" style=\"color: red; cursor: help;\" data-placement=\"right\" data-toggle=\"tooltip\"></i>";
        }
      
        resultsArray.push([
            priority,
            delayed,
            formatAsUserSpecificDate(results[i].EnteredDate),
            formatAsUserSpecificDate(results[i].DueDate),
            results[i].FullAddress,
            results[i].Product,
            orderNo,
            results[i].InspectionStatus === 'N/A' ? 'N/A' : toTitleCase(results[i].InspectionStatus)
        ]);
    }
    $('#dataTableOverdueOrders').dataTable().fnDestroy();
    $('#dataTableOverdueOrders')
        .DataTable({
            responsive: true,
            data: resultsArray,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
           // sScrollXInner: "100%",
            pageLength: _pageLength20,
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, resultsArray.length <= 1);
                $('.dataTables_scrollBody').scrollTop(0);
            },
            columnDefs: [
                { targets: 0, sClass: "width-100 td-align-m" },
                { targets: 1, sClass: "width-40 td-align-m" },
                { targets: 2, sClass: "width-110" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-200" },
                { targets: 5, sClass: "width-130" },
                { targets: 6, sClass: "width-80" },
                { targets: 7, sClass: "width-130", "visible": false },
                { targets: "_all", "defaultContent": "" }
            ]

        });
    $('#dataTableOverdueOrders').dataTable().fnPageChange(0);
}

function loadDueOrdersTable(results) {
    var resultsArray = [];

    for (var i = 0; i < results.length; i++) {

        var url = "OrderStatus.aspx?on=" + results[i].OrderNo + "&it=" + results[i].ItemNo + "&rs=1";
        var orderNo = "<a style='cursor:pointer;' onclick='window.open(\"" + url + "\",\"_blank\");'>" + results[i].OrderNo + "</a>";
        var priority = "";
        var delayed = results[i].Delayed ? getOnHoldIndicatorIcon() : "";
        if (results[i].HighValue === true) {
            priority = "<i id=\"iconPriority\" class=\"fa fa-exclamation-triangle\" title=\"Priority\" style=\"color: red; cursor: help;\" data-placement=\"right\" data-toggle=\"tooltip\"></i>";
        }
        resultsArray.push([
            priority,
            delayed,
            formatAsUserSpecificDate(results[i].EnteredDate),
            formatAsUserSpecificDate(results[i].DueDate),
            results[i].FullAddress,
            results[i].Product,
            orderNo,
            results[i].InspectionStatus === 'N/A' ? 'N/A' : toTitleCase(results[i].InspectionStatus)
        ]);
    }
    $('#dataTableDueOrders').dataTable().fnDestroy();
    $('#dataTableDueOrders')
        .DataTable({
            responsive: true,
            data: resultsArray,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
           // sScrollXInner: "100%",
            pageLength: _pageLength20,
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, resultsArray.length <= 1);
                $('.dataTables_scrollBody').scrollTop(0);
            },
            columnDefs: [
                { targets: 0, sClass: "width-100 td-align-m" },
                { targets: 1, sClass: "width-40 td-align-m" },
                { targets: 2, sClass: "width-110" },
                { targets: 3, sClass: "width-110" },
                { targets: 4, sClass: "width-200" },
                { targets: 5, sClass: "width-130" },
                { targets: 6, sClass: "width-80" },
                { targets: 7, sClass: "width-130", "visible": false },
                { targets: "_all", "defaultContent": "" }
            ]

        });
    $('#dataTableDueOrders').dataTable().fnPageChange(0);
}

function loadInspectedOrdersTable(results) {
    var resultsArray = [];

    for (var i = 0; i < results.length; i++) {

        var url = "OrderStatus.aspx?on=" + results[i].OrderNo + "&it=" + results[i].ItemNo + "&rs=1";
        var orderNo = "<a style='cursor:pointer;' onclick='window.open(\"" + url + "\",\"_blank\");'>" + results[i].OrderNo + "</a>";
        var priority = "";
        var delayed = results[i].Delayed ? getOnHoldIndicatorIcon() : "";
        if (results[i].HighValue === true) {
            priority = "<i id=\"iconPriority\" class=\"fa fa-exclamation-triangle\" title=\"Priority\" style=\"color: red; cursor: help;\" data-placement=\"right\" data-toggle=\"tooltip\"></i>";
        }
        resultsArray.push([
            priority,
            delayed,
            formatAsUserSpecificDate(results[i].EnteredDate),
            formatAsUserSpecificDate(results[i].DueDate),
            results[i].FullAddress,
            results[i].Product,
            orderNo,
            results[i].InspectionStatus === 'N/A' ? 'N/A' : toTitleCase(results[i].InspectionStatus)
        ]);
    }
    $('#dataTableInspectedOrders').dataTable().fnDestroy();

    $('#dataTableInspectedOrders')
        .DataTable({
            responsive: true,
            data: resultsArray,
            autoWidth: false,
            scrollY: "150px",
            scrollCollapse: true,
            scroller: true,
            sScrollX: "100%",
           // sScrollXInner: "100%",
            pageLength: _pageLength20,
            lengthChange: false,
            stateSave: false,
            bFilter: false,
            aaSorting: [],
            fnInitComplete: function () {
                turnOffAutoComplete(this);
            },
            drawCallback: function (settings) {
                updateDataTablePagination(this, resultsArray.length <= 1);
                $('.dataTables_scrollBody').scrollTop(0);
            },
            aoColumnDefs: [
            { targets: 0, sClass: "width-100 td-align-m" },
            { targets: 1, sClass: "width-40 td-align-m" },
            { targets: 2, sClass: "width-110" },
            { targets: 3, sClass: "width-110" },
            { targets: 4, sClass: "width-200" },
            { targets: 5, sClass: "width-130" },
            { targets: 6, sClass: "width-80" },
            { targets: 7, sClass: "width-130" },
            { targets: "_all", "defaultContent": "" }
            ]

        });
    $('#dataTableInspectedOrders').dataTable().fnPageChange(0);
}
// END FULL GRIDS

function ShowOOOModal() {
    $('#radioNotAvailable').closest('div').hide();
    $("#outofofficeModal").modal('show');
    $("#radioNotAvailable").prop('checked', false);
    $("#radioNotAvilableADateRange").prop('checked', false);
    $("#radioAvailable").prop('checked', false);
    $("#" + $$("txtStartDate").attr("id")).val('');
    $("#" + $$("txtenddate").attr("id")).val('');
    $("#divDateRange").hide();
    $("#lblValidation").text("");
}

function HideOOOModal() {
    $("#outofofficeModal").modal('hide');
    $('.modal-backdrop').remove();
    $("#ooomodalbody").removeClass("min-height-270");
}

function NotAvailableDateRangeDiv() {
    $("#divDateRange").show('slow');
    OptionSelected = "2";
    $("#ooomodalbody").addClass("min-height-270");
}

function NotAvailable() {
    $("#divDateRange").hide();
    OptionSelected = "1";
    $("#ooomodalbody").removeClass("min-height-270");
    $("#lblValidation").text("");
}

function Available() {
    $("#divDateRange").hide();
    OptionSelected = "3";
    $("#ooomodalbody").removeClass("min-height-270");
    $("#lblValidation").text("");
}

function SaveOOOSettings() {

    if (OptionSelected == "1") {
        StartDate = moment(new Date()).format('MM/DD/YYYY');
        EndDate = null;
    }
    if (OptionSelected == "3") {
        StartDate = null;
        EndDate = null;
    }

    if (OptionSelected == "") {
        $("#lblValidation").text("Please select a valid out of office option.");
        return;
    }
    if (OptionSelected == "2") {
        StartDate = $("#" + $$("txtStartDate").attr("id")).val();
        EndDate = $("#" + $$("txtenddate").attr("id")).val();

        var start = new Date(StartDate);
        var end = new Date(EndDate);

        if ((!StartDate || !EndDate) || (start >= end)) {
            $("#lblValidation").text("Please enter a valid start and return date.");
            return;
        }
    }
    

    var jsonText = $.toJSON({
        vendorId: VendorId,
        startDate: StartDate,
        endDate: EndDate,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/UpdateVendorOooSettings",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.Result);
                return '';
            }

            if (OptionSelected == "1");
            {
                $("#" + $$("lbloutofoffice").attr("id")).text(OUT_OF_OFFICE_MSG);

            }
            if (OptionSelected == "2") {
                $("#" + $$("lbloutofoffice").attr("id")).text("Out of office enabled by vendor from " + StartDate + ", until " + EndDate);

            }
            if (OptionSelected == "3") {
                $("#" + $$("lbloutofoffice").attr("id")).text("Available");

            }
            HideOOOModal();
            return true;
        });

}

//#region VendorUsers
function registerVendorUsersEvents() {
    $("#msgAttachment").on("click", function () {
        var docpath = encodeURI("../../viewer.aspx?display=1&docPath=" + $(this).attr("data-docpath"));
        window.open(docpath);
        return false;
    });
    $("#btnSaveMessage").on("click", function () {
        markVendorUsersMessageStatus(false);
        return false;
    });
    $("#btnDeleteMessage").on("click", function () {
        markVendorUsersMessageStatus(true);
        return false;
    });
};
function loadVendorUsersMessages(messageRead) {
    var jsonText = $.toJSON({
        contactId: um_hdnContactId,
        messageRead: messageRead,
        transactionId: $("#" + window.dm_ViewId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/GetContactMessages",
        jsonText,
        function (msg) {
            var data = msg.d.Data;
            $("#" + window.dm_ViewId).val(msg.d.TransactionId);
            if (msg.d.Success !== true) {
                ShowError(msg.d.ErrorMessage);
                closeVendorUsersModalMessage();
                return false;
            }
            if (data === null) return false;
            var first = Enumerable.From(data).Where("!$.MessageRead && $.Priority === 'High'").FirstOrDefault();
            if (first) {
                showVendorUsersModalMessage(first);
            } else {
                closeVendorUsersModalMessage();
            }
            return true;
        },
        function (error) {
            ShowError(JSON.parse(error.responseText).Message);
            closeVendorUsersModalMessage();
        });
};
function showVendorUsersModalMessage(data) {
    resetVendorUsersModalMessage();
    if (data.AttachmentName) {
        $("#msgAttachment").attr("data-docpath", data.AttachmentFilePath).html(data.AttachmentName);
        $("#attachmentContainer").show();
    } else {
        $("#attachmentContainer").hide();
    }
    $("#messageId").text(data.MessageId);
    $("#msgSubject").html(data.Subject);
    $("#msgBody").html(data.Message);
    $("#msgDate").html(moment(data.SendEmailAt, "MM/DD/YYYY").format("MM/DD/YYYY"));
    $("#highPriorityMessagesModal").modal("show");
    $(".modal-backdrop").hide();
};
function markVendorUsersMessageStatus(messageDeleted) {
    var jsonText = $.toJSON({
        contactId: um_hdnContactId,
        messageId: $("#messageId").text(),
        messageRead: true,
        messageDeleted: messageDeleted,
        transactionId: $("#" + window.dm_TransactionId).val()
    });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/SaveContactMessage", jsonText,
        function (msg) {
            $("#" + window.dm_TransactionId).val(msg.d.TransactionId);
            if (!msg.d.Success) {
                ShowError(msg.d.ErrorMessage);
                closeVendorUsersModalMessage();
            }
            else {
                loadVendorUsersMessages(false);
            }
            return msg.d.Success;
        },
        function (data) {
            ShowError(data.responseJSON.Message);
        });
};
function resetVendorUsersModalMessage() {
    $("#attachmentContainer").hide();
    $("#messageId").text("");
    $("#msgBody").html("");
    $("#msgDate").html("");
};
function closeVendorUsersModalMessage() {
    $("#highPriorityMessagesModal").modal("hide");
};


//#endregion
