/*!
 * Signature Pad v3.0.0-beta.3 | https://github.com/szimek/signature_pad
 * (c) 2018 Szymon Nowak | Released under the MIT license
 */
(function(n,t){typeof exports=="object"&&typeof module!="undefined"?module.exports=t():typeof define=="function"&&define.amd?define(t):n.SignaturePad=t()})(this,function(){"use strict";function i(n,t){t===void 0&&(t=250);var f=0,i=null,e,r,u,o=function(){f=Date.now();i=null;e=n.apply(r,u);i||(r=null,u=[])};return function(){for(var c,h,l=[],s=0;s<arguments.length;s++)l[s]=arguments[s];return c=Date.now(),h=t-(c-f),r=this,u=l,h<=0||h>t?(i&&(clearTimeout(i),i=null),f=c,e=n.apply(r,u),i||(r=null,u=[])):i||(i=window.setTimeout(o,h)),e}}var n=function(){function n(n,t,i){this.x=n;this.y=t;this.time=i||Date.now()}return n.prototype.distanceTo=function(n){return Math.sqrt(Math.pow(this.x-n.x,2)+Math.pow(this.y-n.y,2))},n.prototype.equals=function(n){return this.x===n.x&&this.y===n.y&&this.time===n.time},n.prototype.velocityFrom=function(n){return this.time!==n.time?this.distanceTo(n)/(this.time-n.time):0},n}(),t=function(){function t(n,t,i,r,u,f){this.startPoint=n;this.control2=t;this.control1=i;this.endPoint=r;this.startWidth=u;this.endWidth=f}return t.fromPoints=function(n,i){var r=this.calculateControlPoints(n[0],n[1],n[2]).c2,u=this.calculateControlPoints(n[1],n[2],n[3]).c1;return new t(n[1],r,u,n[2],i.start,i.end)},t.calculateControlPoints=function(t,i,r){var e=t.x-i.x,o=t.y-i.y,s=i.x-r.x,h=i.y-r.y,f={x:(t.x+i.x)/2,y:(t.y+i.y)/2},u={x:(i.x+r.x)/2,y:(i.y+r.y)/2},p=Math.sqrt(e*e+o*o),c=Math.sqrt(s*s+h*h),w=f.x-u.x,b=f.y-u.y,l=c/(p+c),a={x:u.x+w*l,y:u.y+b*l},v=i.x-a.x,y=i.y-a.y;return{c1:new n(f.x+v,f.y+y),c2:new n(u.x+v,u.y+y)}},t.prototype.length=function(){for(var t,i,r=10,u=0,f,e,n=0;n<=r;n+=1){var o=n/r,s=this.point(o,this.startPoint.x,this.control1.x,this.control2.x,this.endPoint.x),h=this.point(o,this.startPoint.y,this.control1.y,this.control2.y,this.endPoint.y);n>0&&(t=s-f,i=h-e,u+=Math.sqrt(t*t+i*i));f=s;e=h}return u},t.prototype.point=function(n,t,i,r,u){return t*(1-n)*(1-n)*(1-n)+3*i*(1-n)*(1-n)*n+3*r*(1-n)*n*n+u*n*n*n},t}();return function(){function r(n,t){t===void 0&&(t={});var u=this;this.canvas=n;this.options=t;this._handleMouseDown=function(n){n.which===1&&(u._mouseButtonDown=!0,u._strokeBegin(n))};this._handleMouseMove=function(n){u._mouseButtonDown&&u._strokeMoveUpdate(n)};this._handleMouseUp=function(n){n.which===1&&u._mouseButtonDown&&(u._mouseButtonDown=!1,u._strokeEnd(n))};this._handleTouchStart=function(n){if(n.preventDefault(),n.targetTouches.length===1){var t=n.changedTouches[0];u._strokeBegin(t)}};this._handleTouchMove=function(n){n.preventDefault();var t=n.targetTouches[0];u._strokeMoveUpdate(t)};this._handleTouchEnd=function(n){var i=n.target===u.canvas,t;i&&(n.preventDefault(),t=n.changedTouches[0],u._strokeEnd(t))};this.velocityFilterWeight=t.velocityFilterWeight||.7;this.minWidth=t.minWidth||.5;this.maxWidth=t.maxWidth||2.5;this.throttle="throttle"in t?t.throttle:16;this.minDistance="minDistance"in t?t.minDistance:5;this._strokeMoveUpdate=this.throttle?i(r.prototype._strokeUpdate,this.throttle):r.prototype._strokeUpdate;this.dotSize=t.dotSize||function(){return(this.minWidth+this.maxWidth)/2};this.penColor=t.penColor||"black";this.backgroundColor=t.backgroundColor||"rgba(0,0,0,0)";this.onBegin=t.onBegin;this.onEnd=t.onEnd;this._ctx=n.getContext("2d");this.clear();this.on()}return r.prototype.clear=function(){var t=this._ctx,n=this.canvas;t.fillStyle=this.backgroundColor;t.clearRect(0,0,n.width,n.height);t.fillRect(0,0,n.width,n.height);this._data=[];this._reset();this._isEmpty=!0},r.prototype.fromDataURL=function(n,t,i){var f=this;t===void 0&&(t={});var r=new Image,u=t.ratio||window.devicePixelRatio||1,e=t.width||this.canvas.width/u,o=t.height||this.canvas.height/u;this._reset();r.onload=function(){f._ctx.drawImage(r,0,0,e,o);i&&i()};r.onerror=function(n){i&&i(n)};r.src=n;this._isEmpty=!1},r.prototype.toDataURL=function(n,t){n===void 0&&(n="image/png");switch(n){case"image/svg+xml":return this._toSVG();default:return this.canvas.toDataURL(n,t)}},r.prototype.on=function(){this.canvas.style.touchAction="none";this.canvas.style.msTouchAction="none";window.PointerEvent?this._handlePointerEvents():(this._handleMouseEvents(),"ontouchstart"in window&&this._handleTouchEvents())},r.prototype.off=function(){this.canvas.style.touchAction="auto";this.canvas.style.msTouchAction="auto";this.canvas.removeEventListener("pointerdown",this._handleMouseDown);this.canvas.removeEventListener("pointermove",this._handleMouseMove);document.removeEventListener("pointerup",this._handleMouseUp);this.canvas.removeEventListener("mousedown",this._handleMouseDown);this.canvas.removeEventListener("mousemove",this._handleMouseMove);document.removeEventListener("mouseup",this._handleMouseUp);this.canvas.removeEventListener("touchstart",this._handleTouchStart);this.canvas.removeEventListener("touchmove",this._handleTouchMove);this.canvas.removeEventListener("touchend",this._handleTouchEnd)},r.prototype.isEmpty=function(){return this._isEmpty},r.prototype.fromData=function(n){var t=this;this.clear();this._fromData(n,function(n){var i=n.color,r=n.curve;return t._drawCurve({color:i,curve:r})},function(n){var i=n.color,r=n.point;return t._drawDot({color:i,point:r})});this._data=n},r.prototype.toData=function(){return this._data},r.prototype._strokeBegin=function(n){var t={color:this.penColor,points:[]};if(typeof this.onBegin=="function")this.onBegin(n);this._data.push(t);this._reset();this._strokeUpdate(n)},r.prototype._strokeUpdate=function(n){var o=n.clientX,s=n.clientY,t=this._createPoint(o,s),f=this._data[this._data.length-1],r=f.points,i=r.length>0&&r[r.length-1],h=i?t.distanceTo(i)<=this.minDistance:!1,e=f.color,u;i&&i&&h||(u=this._addPoint(t),i?u&&this._drawCurve({color:e,curve:u}):this._drawDot({color:e,point:t}),r.push({time:t.time,x:t.x,y:t.y}))},r.prototype._strokeEnd=function(n){if(this._strokeUpdate(n),typeof this.onEnd=="function")this.onEnd(n)},r.prototype._handlePointerEvents=function(){this._mouseButtonDown=!1;this.canvas.addEventListener("pointerdown",this._handleMouseDown);this.canvas.addEventListener("pointermove",this._handleMouseMove);document.addEventListener("pointerup",this._handleMouseUp)},r.prototype._handleMouseEvents=function(){this._mouseButtonDown=!1;this.canvas.addEventListener("mousedown",this._handleMouseDown);this.canvas.addEventListener("mousemove",this._handleMouseMove);document.addEventListener("mouseup",this._handleMouseUp)},r.prototype._handleTouchEvents=function(){this.canvas.addEventListener("touchstart",this._handleTouchStart);this.canvas.addEventListener("touchmove",this._handleTouchMove);this.canvas.addEventListener("touchend",this._handleTouchEnd)},r.prototype._reset=function(){this._lastPoints=[];this._lastVelocity=0;this._lastWidth=(this.minWidth+this.maxWidth)/2;this._ctx.fillStyle=this.penColor},r.prototype._createPoint=function(t,i){var r=this.canvas.getBoundingClientRect();return new n(t-r.left,i-r.top,(new Date).getTime())},r.prototype._addPoint=function(n){var i=this._lastPoints,r,u;return(i.push(n),i.length>2)?(i.length===3&&i.unshift(i[0]),r=this._calculateCurveWidths(i[1],i[2]),u=t.fromPoints(i,r),i.shift(),u):null},r.prototype._calculateCurveWidths=function(n,t){var i=this.velocityFilterWeight*t.velocityFrom(n)+(1-this.velocityFilterWeight)*this._lastVelocity,r=this._strokeWidth(i),u={end:r,start:this._lastWidth};return this._lastVelocity=i,this._lastWidth=r,u},r.prototype._strokeWidth=function(n){return Math.max(this.maxWidth/(n+1),this.minWidth)},r.prototype._drawCurveSegment=function(n,t,i){var r=this._ctx;r.moveTo(n,t);r.arc(n,t,i,0,2*Math.PI,!1);this._isEmpty=!1},r.prototype._drawCurve=function(n){var y=n.color,t=n.curve,f=this._ctx,p=t.endWidth-t.startWidth,l=Math.floor(t.length())*2,e,u,v;for(f.beginPath(),f.fillStyle=y,e=0;e<l;e+=1){var i=e/l,s=i*i,h=s*i,r=1-i,c=r*r,a=c*r,o=a*t.startPoint.x;o+=3*c*i*t.control1.x;o+=3*r*s*t.control2.x;o+=h*t.endPoint.x;u=a*t.startPoint.y;u+=3*c*i*t.control1.y;u+=3*r*s*t.control2.y;u+=h*t.endPoint.y;v=t.startWidth+h*p;this._drawCurveSegment(o,u,v)}f.closePath();f.fill()},r.prototype._drawDot=function(n){var r=n.color,i=n.point,t=this._ctx,u=typeof this.dotSize=="function"?this.dotSize():this.dotSize;t.beginPath();this._drawCurveSegment(i.x,i.y,u);t.closePath();t.fillStyle=r;t.fill()},r.prototype._fromData=function(t,i,r){for(var u,o,a,c,f=0,s=t;f<s.length;f++){var l=s[f],h=l.color,e=l.points;if(e.length>1)for(u=0;u<e.length;u+=1)o=e[u],a=new n(o.x,o.y,o.time),this.penColor=h,u===0&&this._reset(),c=this._addPoint(a),c&&i({color:h,curve:c});else this._reset(),r({color:h,point:e[0]})}},r.prototype._toSVG=function(){var r=this,l=this._data,e=Math.max(window.devicePixelRatio||1,1),o=this.canvas.width/e,s=this.canvas.height/e,n=document.createElementNS("http://www.w3.org/2000/svg","svg"),t,f,i,h,c;n.setAttribute("width",this.canvas.width.toString());n.setAttribute("height",this.canvas.height.toString());this._fromData(l,function(t){var f=t.color,i=t.curve,r=document.createElement("path"),u;isNaN(i.control1.x)||isNaN(i.control1.y)||isNaN(i.control2.x)||isNaN(i.control2.y)||(u="M "+i.startPoint.x.toFixed(3)+","+i.startPoint.y.toFixed(3)+" "+("C "+i.control1.x.toFixed(3)+","+i.control1.y.toFixed(3)+" ")+(i.control2.x.toFixed(3)+","+i.control2.y.toFixed(3)+" ")+(i.endPoint.x.toFixed(3)+","+i.endPoint.y.toFixed(3)),r.setAttribute("d",u),r.setAttribute("stroke-width",(i.endWidth*2.25).toFixed(3)),r.setAttribute("stroke",f),r.setAttribute("fill","none"),r.setAttribute("stroke-linecap","round"),n.appendChild(r))},function(t){var f=t.color,u=t.point,i=document.createElement("circle"),e=typeof r.dotSize=="function"?r.dotSize():r.dotSize;i.setAttribute("r",e.toString());i.setAttribute("cx",u.x.toString());i.setAttribute("cy",u.y.toString());i.setAttribute("fill",f);n.appendChild(i)});var a='<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"'+(' viewBox="0 0 '+o+" "+s+'"')+(' width="'+o+'"')+(' height="'+s+'"')+">",u=n.innerHTML;if(u===undefined){for(t=document.createElement("dummy"),f=n.childNodes,t.innerHTML="",i=0;i<f.length;i+=1)t.appendChild(f[i].cloneNode(!0));u=t.innerHTML}return h="<\/svg>",c=a+u+h,"data:image/svg+xml;base64,"+btoa(c)},r}()});