﻿function PasswordReset(instanceName) {
    var passwordRule = "";

    var instance = instanceName;

    var dialogTemplate =
            "<div class='row hideControl modal modalBackground' id='divChangePasswordModal[INSTANCE]'>" +
            "	<div class='col-lg-3'></div>" +
            "	<div class='col-lg-6 modal-dialog'>" +
            "		<div class='widget' style='margin: 60px auto;'>" +
            "			<div class='widget-header'>" +
            "				<span class='widget-caption'>Change Password</span>" +
            "               <button id='closeDialog[INSTANCE]' onclick='javascript:[INSTANCE].cancel(); return false;' class='close' style='color: white; font-size: 21px; padding-right: 15px'>×</button>" +
            "			</div>" +
            "			<div class='widget-body'>" +
            "				<div class='row'>" +
            "					<div class='col-lg-12'>" +
            "						<label class='addProductLabel'><h4>Password Requirements: </h4>&nbsp;[PASSWORDRULE]</label>" +
            "					</div>" +
            "					<div class='col-lg-12'>" +
            "						<label></label>" +
            "					</div>" +
            "					<div class='col-lg-12'>" +
            "						<div class='row' style='text-align: left;'>" +
            "							<div class='col-lg-5'>" +
            "								<label style='text-align: left;'>Current Password: </label><span class='labelError' id='oldPasswordRequired[INSTANCE]'>*</span>" +
            "							</div>" +
            "							<div class='col-lg-7' style='padding-bottom:5px;'>" +						
            "								<input type='password' id='oldPassword[INSTANCE]' autocomplete='new-password' class='fieldcontrol form-control' />" +
            "							</div>" +
            "						</div>" +
                "						<div class='row' style='text-align: left;'>" +
                "							<div class='col-lg-5'>" +
                "								<label style='text-align: left;'>New Password: </label>" +
                "								<span class='labelError' id='newPasswordRequired[INSTANCE]'>*</span>" +
                "							</div>" +
                "							<div class='col-lg-7' style='padding-bottom:5px;'>" +

                "								<input type='password' id='newPassword[INSTANCE]' autocomplete='new-password' class='fieldcontrol form-control' />" +
                "							</div>" +
                "						</div>" +
                "						<div class='row' style='text-align: left;'>" +
                "							<div class='col-lg-5'>" +
                "								<label style='text-align: left;'>Retype Password: </label>" +
                "								<span class='labelError' id='verifyPasswordRequired[INSTANCE]'>*</span>" +
                "							</div>" +
                "							<div class='col-lg-7' style='padding-bottom:5px;'>" +
                "								<input type='password' id='verifyPassword[INSTANCE]' autocomplete='new-password' class='fieldcontrol form-control' />" +
                "							</div>" +
                "						</div>" +
            "						<div class='row'>" +
            "							<div style='text-align: center'>" +
            "								<label class='labelError' id='error[INSTANCE]' >&nbsp;</label>" +
            "							</div>" +
            "						</div>" +
            "				</div>" +
            "				</div>" +
            "				<div class='row'>" +
            "					<div class='col-lg-6' style='padding-left: 15px;'>" +
            "						<button id='cancelPasswordChange[INSTANCE]' type='button' onclick='[INSTANCE].cancel();' class='btn btn-danger btn-flat pull-left'>" +
            "							<i class='fa fa-remove'></i>&nbsp;<span style='font-size: 16px;'>Cancel</span>" +
            "						</button>" +
            "					</div>" +
            "					<div class='col-lg-6' style='padding-right: 15px;'>" +
            "						<button id='submitPasswordChange[INSTANCE]' type='button' onclick='[INSTANCE].attemptPasswordChange();' style='width: 100px' class='btn btn-primary btn-flat pull-right'>" +
            "							<i class='fa fa-check'></i>&nbsp;<span style='font-size: 16px;'>Save</span>" +
            "						</button>" +
            "					</div>" +
            "				</div>" +
            "			</div>" +
            "		</div>" +
            "	</div>" +
            "	<div class='col-lg-3'></div>" +
            "</div>";


    this.init = function () {
        var deferred = $.Deferred();

        if (passwordRule !== "") {
            deferred.resolve("Ok");
        } else {
            $.ajax({
                type: "POST",
                url: "../../WebServices/DataAccessServiceJson.asmx/GetPasswordRule",
                data: $.toJSON({ viewId: $("#" + window.dm_ViewId).val() }),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (msg) {
                    msg = $.parseJSON(msg.d);
                    passwordRule = msg.Data;

                    dialogTemplate = dialogTemplate.replace(/\[INSTANCE\]/g, instance);
                    dialogTemplate = dialogTemplate.replace(/\[PASSWORDRULE\]/g, passwordRule);
                    if ($("#divChangePasswordModal").length === 0) {
                        $(".content").append(dialogTemplate);
                    }
                    deferred.resolve("Ok");
                },
                error: function (data) {
                    data = $.parseJSON(data.d);
                    ShowError(data.d.Result);
                    deferred.reject(data.d.Result);
                }
            });
        }
        return deferred.promise();
    };

    this.setError = function (errorText) {
        var errorLabelElement = "#error[INSTANCE]";
        errorLabelElement = errorLabelElement.replace(/\[INSTANCE\]/g, instance);
        $(errorLabelElement).text(errorText);
    };

    this.cancelPasswordChangeElement = function () {
        var cancelPasswordChangeElement = "#cancelPasswordChange[INSTANCE]";
        cancelPasswordChangeElement = cancelPasswordChangeElement.replace(/\[INSTANCE\]/g, instance);
        return $(cancelPasswordChangeElement);
    };

    this.submitPasswordChangeElement = function () {
        var submitPasswordChangeElement = "#submitPasswordChange[INSTANCE]";
        submitPasswordChangeElement = submitPasswordChangeElement.replace(/\[INSTANCE\]/g, instance);
        return $(submitPasswordChangeElement);
    };

    this.oldPasswordElement = function () {
        var oldPasswordElement = "#oldPassword[INSTANCE]";
        oldPasswordElement = oldPasswordElement.replace(/\[INSTANCE\]/g, instance);
        return $(oldPasswordElement);
    };

    this.oldPasswordRequiredElement = function () {
        var oldPasswordRequiredElement = "#oldPasswordRequired[INSTANCE]";
        oldPasswordRequiredElement = oldPasswordRequiredElement.replace(/\[INSTANCE\]/g, instance);
        return $(oldPasswordRequiredElement);
    };

    this.newPasswordElement = function () {
        var newPasswordElement = "#newPassword[INSTANCE]";
        newPasswordElement = newPasswordElement.replace(/\[INSTANCE\]/g, instance);
        return $(newPasswordElement);
    };

    this.newPasswordRequiredElement = function () {
        var newPasswordElement = "#newPasswordRequired[INSTANCE]";
        newPasswordElement = newPasswordElement.replace(/\[INSTANCE\]/g, instance);
        return $(newPasswordElement);
    };

    this.verifyPasswordElement = function () {
        var verifyPasswordElement = "#verifyPassword[INSTANCE]";
        verifyPasswordElement = verifyPasswordElement.replace(/\[INSTANCE\]/g, instance);
        return $(verifyPasswordElement);
    };

    this.verifyPasswordRequiredElement = function () {
        var verifyPasswordRequiredElement = "#verifyPasswordRequired[INSTANCE]";
        verifyPasswordRequiredElement = verifyPasswordRequiredElement.replace(/\[INSTANCE\]/g, instance);
        return $(verifyPasswordRequiredElement);
    };

    this.attemptPasswordChange = function () {

        var oldPassword = this.oldPasswordElement().val();
        var newPassword = this.newPasswordElement().val();
        var verifyPassword = this.verifyPasswordElement().val();

        this.oldPasswordRequiredElement().hide();
        this.newPasswordRequiredElement().hide();
        this.verifyPasswordRequiredElement().hide();
        this.oldPasswordRequiredElement().hide();
        this.setError("");

        if (oldPassword === "") {
            this.oldPasswordRequiredElement().show();
        }

        if (newPassword === "") {
            this.newPasswordRequiredElement().show();
        }

        if (verifyPassword === "") {
            this.verifyPasswordRequiredElement().show();
        }

        if (oldPassword === "" | newPassword === "" || verifyPassword === "") {
            this.setError("Please fill in all required fields.");
            return;
        }

        if (newPassword !== verifyPassword) {
            this.setError("New and retyped passwords do not match.");
            return;
        }

        var cancelButton = this.cancelPasswordChangeElement();
        var submitButton = this.submitPasswordChangeElement();

        cancelButton.attr("disabled", "disabled");
        submitButton.attr("disabled", "disabled");

        var current = this;

        $.ajax({
            type: "POST",
            url: "../../WebServices/DataAccessServiceJson.asmx/UpdatePassword",
            data: $.toJSON({ transactionId: $("#" + window.dm_TransactionId).val(), oldpw: oldPassword, newpw: newPassword }),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (msg) {
                
                submitButton.removeAttr("disabled");
                cancelButton.removeAttr("disabled");

                msg = $.parseJSON(msg.d);

                $("#" + window.dm_TransactionId).val(msg.TransactionId);
                if (msg.Success) {
                    current.hide();
                    bootbox.alert("Your password has been updated. Please log back in using your new password.", function () {
                        window.location = "../Login/Login.aspx?action=logout";
                    });
                    return;
                }

                var errorMessage = (msg.ErrorMessage === undefined || msg.ErrorMessage === null) ? msg.Result : msg.ErrorMessage;

                current.setError(errorMessage);
                //bootbox.alert(errorMessage);

            },
            error: function (data) {
                submitButton.removeAttr("disabled");
                cancelButton.removeAttr("disabled");
                data = $.parseJSON(data.d);
                ShowError(data.d.Result);
            }
        });
    };

    this.show = function () {
        var dialogElement = "#divChangePasswordModal[INSTANCE]";
        dialogElement = dialogElement.replace(/\[INSTANCE\]/g, instance);

        this.oldPasswordElement().val("");
        this.newPasswordElement().val("");
        this.verifyPasswordElement().val("");
        this.oldPasswordRequiredElement().hide();
        this.newPasswordRequiredElement().hide();
        this.verifyPasswordRequiredElement().hide();
        this.oldPasswordRequiredElement().hide();
        this.setError("");

        $(dialogElement).modal({
            backdrop: "static",
            keyboard: false
        });
    };

    this.hide = function() {
        var dialogElement = "#divChangePasswordModal[INSTANCE]";
        dialogElement = dialogElement.replace(/\[INSTANCE\]/g, instance);

        $(dialogElement).modal("hide");
    };

    this.cancel = function () {
        var dialogElement = "#divChangePasswordModal[INSTANCE]";
        dialogElement = dialogElement.replace(/\[INSTANCE\]/g, instance);
        $(dialogElement).modal("hide");
    };
};

// example usage: place an instance variable, then init in document.ready event
/*
var standalonePasswordReset = new PasswordReset("standalonePasswordReset");

$(document).ready(function () {

    standalonePasswordReset.init().then(function () {
        standalonePasswordReset.show();
    }, function (exc) {
        alert(exc);
    });

});
*/