﻿//Collateral.js
var wired = false;
var isValid = true;
var _isDirty = false;
var dm_activeLink;
var dm_redirect;
var dm_inititalized;
var dm_TransactionId;
var dm_ViewId;
var webserviceurl = "../../WebServices/DataAccessServiceJson.asmx/";
var vendorid = 0;
var allowedSpecialCharKeyCodes = [46, 8, 37, 39, 35, 36, 9];
var numberKeyCodes = [44, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105];
var commaKeyCode = [188];
var decimalKeyCode = [190, 110];
var ajaxCalls = [];
var _modalFirstElement;
var _modalLastElement;
var _autoSave;
var _autoSaveTime = 600000;
var _urarProductCodes = "a01p,a235,a254,a255,a256,a257";
var _rentalData = [];
var _productCodeMaster;
var _isFNCClient = false;
var _envProducts = "";
var _urarProducts = [];
var _suffix = "";
var _dateFormat = "MM/DD/YYYY";
var _mdyDateFormat = "MM/DD/YYYY";
var _ymdDateFormat = "YYYY/MM/DD";
var _yDateFormat = "YYYY";
var _vnDate = {
    day: "DD",
    month: "MM",
    year: "YYYY",
    localTime: "LT",
    monthDayYear: "MM/DD/YYYY",
    monthDayYearHour: "MM/DD/YYYY HH",
    monthDayYearHourMin: "MM/DD/YYYY HH:mm",
    monthDayYearHourMinSec: "MM/DD/YYYY HH:mm:ss",
    monthDayYearHourMinSecA: "MM/DD/YYYY HH:mm:ss A",
    monthDayYearHourMinSecAZ: "MM/DD/YYYY HH:mm:ss A z",
    yearMonthDay: "YYYY/MM/DD",
};
var _contactId = 0;
var _gseMitMaxAllowedImages = 0;
var _winScrollPos = 0; // function () { return $(window).scrollTop(); };
var _mlsProperties =
    ["UnparsedAddress"
        , "City"
        , "StateOrProvince"
        , "PostalCode"
        , "PostalCodePlus4"
        , "AssessorPropertySubType"
        , "PropertySubType"
        , "PropertyType"
        , "Distance"
        , "ClosePrice"
        , "ListPrice"
        , "MlsStatus"
        , "ListingType"
        , "PricePerSquareFeet"
        , "MlsListingNumber"
        , "DaysOnMarket"
        , "CloseDate"
        , "ListingContractDate"
        , "LocationFactors"
        , "LotSizeDimensions"
        , "LotSizeSquareFeet"
        , "LotFeatures"
        , "View"
        , "ViewFactors"
        , "ArchitecturalStyle"
        , "YearBuilt"
        , "BedroomsTotal"
        , "BathroomsDecimal"
        , "RoomsTotal"
        , "LivingArea"
        , "Basement"
        , "BasementType"
        , "BasementEntry"
        , "Heating"
        , "HeatingType"
        , "Cooling"
        , "CoolingType"
        , "SolarPowerYN"
        , "GarageYN"
        , "CarStorageType"
        , "GarageSpaces"
        , "ParkingFeatures"
        , "PatioAndPorchFeatures"
        , "ExteriorFeatures"
        , "PoolType"
        , "FireplacesTotal"
        , "FireplaceFeatures"
        , "HighSchoolDistrict"
        , "PublicRemarks"];
var _publicRecords =
    ["ArchitecturalStyle"
        , "AssessedValue"
        , "AssessedYear"
        , "BathroomsTotalInteger"
        , "BedroomsTotal"
        , "BelowGradeFinishedArea"
        , "BelowGradeTotalArea"
        , "CarStorageType"
        , "CensusTractId"
        , "DistressYN"
        , "GarageArea"
        , "GarageSpaces"
        , "ImprovementsValue"
        , "LandValue"
        , "LastSaleBuyerName"
        , "LastSaleDate"
        , "LastSalePrice"
        , "LastSaleRecordingDate"
        , "LastSaleSellerName"
        , "LastSaleType"
        , "LegalSubDivisionName"
        , "LivingArea"
        , "LotSizeSquareFeet"
        , "MlsListingNumber"
        , "OwnerName"
        , "OwnerOccupied"
        , "ParcelNumber"
        , "PmxPropertyId"
        , "PropertySubType"
        , "RoomsTotal"
        , "SaleDocType"
        , "StoriesDescription"
        , "TaxLegalDescription"
        , "YearBuilt"];
var _orderDataBag = {};
var _pages = { iu: {}, vm: {} };
var _enum = {};
var _bias = { keywords: [], htmlData: "", modalVisible: false, isDirty: false };
var _bootboxYesNoConfirmButtons = {
    'confirm': {
        label: '<i class="fa fa-check"></i>&nbsp;Yes',
        className: 'btn btn-primary btn-flat pull-right width-100'
    },
    'cancel': {
        label: '<i class="fa fa-remove"></i>&nbsp;No',
        className: 'btn btn-danger btn-flat pull-left bold width-100'
    }
};
var _bootboxOkButton = {
    confirm: { label: '<i class="fa fa-check"></i>&nbsp;OK', className: "btn btn-primary btn-flat pull-right width-100 font-16" },
    cancel: { className: "btn-danger width-100 font-16 hide" }
};
var _tagMasks = { ein: ["XX-XXX0000", "00-0000000"], ssn: ["XXX-XX-0000", "000-00-0000"] };
$(function () {
    let urlPrefix = location.href.split("?")[0].substring(0, location.href.split("?")[0].lastIndexOf("/"));
    _productCodeMaster = valueOrText("hdnProductCode_Master").toLowerCase();
    _isFNCClient = stringToBoolean(valueOrText("hdnIsFNCClient_Master"));
    _envProducts = valueOrText("hdnENVProducts_Master").split(",");
    _urarProducts = isNullOrWhiteSpace(valueOrText("hdnURARProducts_Master")) ? [] : removeAllWhiteSpaces(valueOrText("hdnURARProducts_Master").toLowerCase()).split(",");
    _suffix = valueOrText("hdnSuffix_Master");
    var orderDataBag = JSON.parse(isNullOrWhiteSpace(valueOrText("hdnOrderDataBag_Master")) ? "{}" : valueOrText("hdnOrderDataBag_Master"));
    orderDataBag.transactionDetails = Object.freeze(orderDataBag.transactionDetails);
    _orderDataBag = Object.freeze(orderDataBag);
    _pages = {
        gwDataCollectionReview: string.format("{0}/GWDataCollectionReview?on={1}&it={2}", urlPrefix, _orderDataBag.orderNo, _orderDataBag.itemNo),
        iu: {},
        vm: {
            orderDashboard: string.format("{0}/OrderStatus?on={1}&it={2}&rs=1", urlPrefix, _orderDataBag.orderNo, _orderDataBag.itemNo)
        }
    };
    let pageName = valueOrText("pagename");
    if (!["OrderTracking/OrderResults", "OrderTracking/WorkQueues"].includes(pageName) && _orderDataBag.suffix === "IU") {
        sessionStorage.clear();
    }
    getDomElementById("hdnOrderDataBag_Master").val("");
    _contactId = intOrDefault(getDomElementById("hdnContactId_Master").val());
    InitMaster();
    ActivateProperMenu();
    setCharacterLimitation();
    loadOrdersByVendorId();
    loadDashboardBadges();
    useCommonTooltips();
    setModalShownEvent();
    setModalClosedEvent();
    toggleSidebar();
    //
    if (_suffix === "IU") {
        $("#otsidebarmenu > li > ul.nav.sidebar-menu > li.treeview:not(#limessages)").on("click", function (e) {
            if ($("#messagesangleicon").hasClass("fa-angle-down")) {
                $("#menumessagefolders").removeClass("menu-open");
                $("#limessages").removeClass("active");
                $("#messagesangleicon").toggleClass("fa-angle-right fa-angle-down");
            }
        });
    }
    buildEnum();
    if (["APPRAISERDASHBOARD", "DATACOLLECTORDASHBOARD"].includes(getPageNameFromURL()) && _orderDataBag.suffix === _enum.suffix.vendor) {
        $.postJson(getAjaxUrl("UpdateUserScreenResolution"), { contactId: _orderDataBag.contactId, screenWidth: _enum.displayResolution.actualScreen.w, screenHeight: _enum.displayResolution.actualScreen.h });
    }
    handleScriptingTags();
    $("input").on("focus", (event) => { $(event.target).select(); });
    //preventExtendedASCIIcharacters("body");// commented out until further notice
    $("a").toArray().forEach(x => {
        let hasAttr = x.hasAttribute("href");
        if (hasAttr) {
            let cssHref = $(x).attr("href").trim();
            if (cssHref === "#") {
                $(x).removeAttr("href").addClass("cursor-p");
            }
        }
    });
    preventAutoComplete();
    setTimeout(function () {
        $("[data-toggle='popover']").popover({ html: true, container: 'body' });
    }, 1000);
});
function getPageName() {
    return valueOrText("pagename").toUpperCase();
}
function saveSidebarState() {
    setTimeout(() => {
        if (exists(typeof window.Storage)) {
            sessionStorage.setItem("SidebarCollapsed", getDomElementById("imglogomini").is(":visible"));
        }
    }, 100);
}
function toggleSidebar() {
    if (exists(typeof window.Storage) && ["Layout", "DataCollectorLayout"].contains(_orderDataBag.appRVP)) {
        if (stringToBoolean(sessionStorage.getItem("SidebarCollapsed"))) {
            $("body").addClass('sidebar-collapse');
        } else {
            $("body").removeClass('sidebar-collapse');
        }
    }
}
function preventAutoComplete(delay = 150) {
    $("input[type='text'], input[type='password'], input[type='search']").attr("autocomplete", "new-password");
    setTimeout(function () {
        $("input[type='search']").toArray().forEach(textfield => {
            if (_orderDataBag.userName === textfield.value) {
                textfield.value = "";
            }
        });
    }, delay);
}
function handleScriptingTags() {
    document.addEventListener("keyup", (event) => {
        let charCode = (event.which) ? event.which : event.keyCode;
        if (charCode === _keyCodes.lessThan) {
            event.target.value = event.target.value.replace("<", "LESS THAN ");
        } else if (charCode === _keyCodes.greaterThan) {
            event.target.value = event.target.value.replace(">", "GREATER THAN ");
        }
    });
    $("input[type='text'], textarea").on("paste", (event) => {
        let target = event.target;
        let position = target.selectionStart;
        let clipboardData = "";
        try {
            clipboardData = event.originalEvent.clipboardData.getData("text");//Chrome
        }
        catch (e) {
            clipboardData = window.clipboardData.getData("text");//IE
        }
        setTimeout(function () {
            target.value = target.value.replaceAll("<", "LESS THAN").replaceAll(">", "GREATER THAN");
            target.selectionEnd = position + clipboardData.replaceAll("<", "LESS THAN").replaceAll(">", "GREATER THAN").length;
        }, 0);
    });
}
function buildEnum() {
    Object.defineProperty(_enum, "propertyTypes", { value: { "coOp": { refId: 1, text: "Co-op", value: "Co-op" }, "condominium": { refId: 2, text: "Condominium", value: "Condominium" }, "manufactured": { refId: 3, text: "Manufactured", value: "Manufactured" }, "mobile": { refId: 4, text: "Mobile", value: "Mobile" }, "modular": { refId: 5, text: "Modular", value: "Modular" }, "multiFamily": { refId: 6, text: "Multi Family", value: "Multi Family" }, "singleFamily": { refId: 7, text: "Single Family", value: "Single Family" }, "townhouse": { refId: 8, text: "Townhouse", value: "Townhouse" }, "vacantLand": { refId: 8, text: "Vacant Land", value: "Vacant Land" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "gsePropertyTypes", { value: { "coOp": { refId: 1, text: "Co-op", value: "Co-op" }, "commercial": { refId: 2, text: "Commercial", value: "Commercial" }, "condo": { refId: 3, text: "Condo", value: "Condo" }, "condoTel": { refId: 4, text: "CondoTel", value: "CondoTel" }, "landOnly": { refId: 5, text: "Land Only", value: "Land Only" }, "manufactured": { refId: 6, text: "Manufactured", value: "Manufactured" }, "mobileLandAttached": { refId: 7, text: "Mobile/Land Attached", value: "Mobile/Land Attached" }, "modular": { refId: 8, text: "Modular", value: "Modular" }, "multiFamily2Unit": { refId: 9, text: "Multi-Family, 2-unit", value: "Multi-Family, 2-unit" }, "multiFamily3Unit": { refId: 10, text: "Multi-Family, 3-unit", value: "Multi-Family, 3-unit" }, "multiFamily4Unit": { refId: 11, text: "Multi-Family, 4-unit", value: "Multi-Family, 4-unit" }, "singleFamilyAttached": { refId: 12, text: "Single Family Attached", value: "Single Family Attached" }, "singleFamilyDetached": { refId: 13, text: "Single Family Detached", value: "Single Family Detached" }, "townhome": { refId: 14, text: "Townhome", value: "Townhome" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "propertySaleTypes", { value: { "crtOrd": { refId: 1, text: "Court ordered sale", value: "CrtOrd" }, "estate": { refId: 2, text: "Estate sale", value: "Estate" }, "nonArm": { refId: 3, text: "Non-arms length sale", value: "NonArm" }, "relo": { refId: 4, text: "Relocation sale", value: "Relo" }, "reo": { refId: 5, text: "REO sale", value: "REO" }, "armLth": { refId: 6, text: "Arms length sale", value: "ArmLth" }, "retail": { refId: 7, text: "Retail sale", value: "Retail" }, "short": { refId: 8, text: "Short sale", value: "Short" }, "other": { refId: 9, text: "Other", value: "Other" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "propertyStyles", { value: { "_1_Story": { refId: 1, text: "1 Story", value: "1 Story" }, "_1_5_Story": { refId: 2, text: "1.5 Story", value: "1.5 Story" }, "_2_Story": { refId: 3, text: "2 Story", value: "2 Story" }, "_3_Plus_Story": { refId: 4, text: "3+ Story", value: "3+ Story" }, "attached": { refId: 5, text: "Attached", value: "Attached" }, "capeCod": { refId: 6, text: "Cape Cod", value: "Cape Cod" }, "colonial": { refId: 7, text: "Colonial", value: "Colonial" }, "contemporary": { refId: 8, text: "Contemporary", value: "Contemporary" }, "craftsman": { refId: 9, text: "Craftsman", value: "Craftsman" }, "duplex": { refId: 10, text: "Duplex", value: "Duplex" }, "farmhouse": { refId: 11, text: "Farmhouse", value: "Farmhouse" }, "georgian": { refId: 12, text: "Georgian", value: "Georgian" }, "highRise": { refId: 13, text: "High Rise", value: "High Rise" }, "logHome": { refId: 14, text: "Log Home", value: "Log Home" }, "lowRise": { refId: 15, text: "Low Rise", value: "Low Rise" }, "modern": { refId: 16, text: "Modern", value: "Modern" }, "raisedRanch": { refId: 17, text: "Raised Ranch", value: "Raised Ranch" }, "rambler": { refId: 18, text: "Rambler", value: "Rambler" }, "ranch": { refId: 19, text: "Ranch", value: "Ranch" }, "semiDetached": { refId: 20, text: "Semi-Detached", value: "Semi-Detached" }, "spanish": { refId: 21, text: "Spanish", value: "Spanish" }, "splitFoyer": { refId: 22, text: "Split Foyer", value: "Split Foyer" }, "splitLevel": { refId: 23, text: "Split Level", value: "Split Level" }, "tudor": { refId: 24, text: "Tudor", value: "Tudor" }, "vacantLand": { refId: 25, text: "Vacant Land", value: "Vacant Land" }, "victorian": { refId: 26, text: "Victorian", value: "Victorian" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "gsePropertyStyles", { value: { "bungalowCottage": { refId: 1, text: "Bungalow/Cottage", value: "Bungalow/Cottage" }, "cabin": { refId: 2, text: "Cabin", value: "Cabin" }, "cape": { refId: 3, text: "Cape", value: "Cape" }, "colonial": { refId: 4, text: "Colonial", value: "Colonial" }, "commercial": { refId: 5, text: "Commercial", value: "Commercial" }, "contemp": { refId: 6, text: "Contemp", value: "Contemp" }, "farmHouse": { refId: 7, text: "Farm House", value: "Farm House" }, "frame": { refId: 8, text: "Frame", value: "Frame" }, "landOnly": { refId: 9, text: "Land Only", value: "Land Only" }, "modular": { refId: 10, text: "Modular", value: "Modular" }, "manufactured": { refId: 11, text: "Manufactured", value: "Manufactured" }, "ranch": { refId: 12, text: "Ranch", value: "Ranch" }, "splitBiLevel": { refId: 13, text: "Split/Bi-Level", value: "Split/Bi-Level" }, "townhouse": { refId: 14, text: "Townhouse", value: "Townhouse" }, "townhouseEnd": { refId: 15, text: "Townhouse-End", value: "Townhouse-End" }, "townhouseMid": { refId: 16, text: "Townhouse-Mid", value: "Townhouse-Mid" }, "triMultiLevel": { refId: 17, text: "Tri/Multi-Level", value: "Tri/Multi-Level" }, "tudor": { refId: 18, text: "Tudor", value: "Tudor" }, "victorian": { refId: 19, text: "Victorian", value: "Victorian" }, "other": { refId: 20, text: "Other", value: "Other" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "propertyHeatingTypes", { value: { "fwa": { refId: 1, text: "FWA", value: "FWA" }, "hwbb": { refId: 2, text: "HWBB", value: "HWBB" }, "radiant": { refId: 3, text: "Radiant", value: "Radiant" }, "fuel": { refId: 4, text: "Fuel", value: "Fuel" }, "other": { refId: 5, text: "Other", value: "Other" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "propertyCoolingTypes", { value: { "centralAirConditioning": { refId: 1, text: "Central Air Conditioning", value: "Central Air Conditioning" }, "individual": { refId: 2, text: "Individual", value: "Individual" }, "other": { refId: 3, text: "Other", value: "Other" }, "none": { refId: 4, text: "None", value: "None" } }, writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "suffix", { value: Object.freeze({ "vendor": "VM", "admin": "IU" }), writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "digits", { value: Object.freeze([0,1,2,3,4,5,6,7,8,9]), writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "fileExtensions", { value: Object.freeze({ "bmp": ".bmp", "env": ".env", "gif": ".gif", "jpg": ".jpeg", "jpeg": ".jpeg", "msg": ".msg", "pdf": ".pdf", "rtf": ".rtf", "txt": ".txt", "wps": ".wps", "xls": ".xls", "xlsx": ".xlsx", "xml": ".xml" }), writable: false, enumerable: true, configurable: true });
    Object.defineProperty(_enum, "displayResolution", { value: Object.freeze({ "r1": Object.freeze({ "w": 1366, "h": 768 }), "r2": Object.freeze({ "w": 1400, "h": 1050 }), "r3": Object.freeze({ "w": 1440, "h": 900 }), "r4": Object.freeze({ "w": 1600, "h": 900 }), "r5": Object.freeze({ "w": "1680", "h": 1050 }), "r6": Object.freeze({ "w": 1920, "h": 1080 }), "actualWindow": Object.freeze({ "w": window.innerWidth, "h": window.innerHeight }), "actualScreen": Object.freeze({ "w": window.screen.width, "h": window.screen.height }) }), writable: false, enumerable: true, configurable: true });
}
function handleKeyDownEvent(event, s) {
    if (event) {
        var key = event.keyCode || event.key;
        var isEnterKey = key === _keyCodes.enter;
        var sourceId = event.target.id;
        var modalFirstElementId = exists(_modalFirstElement) ? _modalFirstElement.attr("id") : null;
        var modalLastElementId = exists(_modalLastElement) ? _modalLastElement.attr("id") : null;
        if (event.shiftKey && key === 9 && sourceId === modalFirstElementId) {
            event.preventDefault();
            $(_modalLastElement).focus();
        }
        else if (event.keyCode === 9 && sourceId === modalLastElementId) {
            event.preventDefault();
            $(_modalFirstElement).focus();
        }
        if (isEnterKey) { // Per PBI 16974: VN - ENTER key Logs User Out
            var isInputOrSelect = $(event.target).is("input") || $(event.target).is("select");
            //var widgetOrModalBody = $(event.target).closest(".widget-body");
            var widgetOrModalBody = $(event.target).closest("div[class*='-body']");
            if (!exists(widgetOrModalBody) || widgetOrModalBody.length === 0) {
                widgetOrModalBody = $(event.target).closest(".modal-body");
            }
            if (exists(widgetOrModalBody) && widgetOrModalBody.length > 0 && $(widgetOrModalBody).is(":visible")) {
                //var modalSubmitButton = $(widgetOrModalBody).closest(".modal-dialog").find("button").filter(function (e,r) {
                //    var text = (string.empty + (this.textContent || this.innerText)).toUpperCase();
                //    var success = text.indexOf("OK") > -1 || text.indexOf("SAVE") > -1;
                //    return success;
                //});
                var modalDialog = $(widgetOrModalBody).closest(".modal-dialog");
                if (!exists(modalDialog) || modalDialog.length === 0) {
                    modalDialog = $(widgetOrModalBody).closest(".modal");
                }
                var modalSubmitButton = modalDialog.find("button:contains('Save')");
                if (!exists(modalSubmitButton) || modalSubmitButton.length === 0) {
                    modalSubmitButton = modalDialog.find("button:contains('OK')");
                }
                if (!exists(modalSubmitButton) || modalSubmitButton.length === 0) {
                    modalSubmitButton = modalDialog.find("button:contains('Add')");
                }
                if (!exists(modalSubmitButton) || modalSubmitButton.length === 0) {
                    modalSubmitButton = modalDialog.find("button:contains('Update')");
                }
                if (!exists(modalSubmitButton) || modalSubmitButton.length === 0) {
                    modalSubmitButton = modalDialog.find("button.btn.btn-success.btn-flat");
                }
                if (isInputOrSelect && exists(modalSubmitButton) && modalSubmitButton.length > 0) {// && !$(modalSubmitButton).is(":disabled")) {
                    event.preventDefault();
                    if (!$(modalSubmitButton).is(":disabled")) {
                        $(modalSubmitButton).trigger("click");
                    }
                }
            }
        }
    }
}
function onModalShown() {
    $(document).off("keydown", handleKeyDownEvent).on("keydown", handleKeyDownEvent);
}
function setModalShownEvent(callback) {
    $(".modal").on("shown.bs.modal", callback && isFunction(callback) ? callback : onModalShown);
}
function onModalHidden(evt) {
    _modalFirstElement = null;
    _modalLastElement = null;
    _formValidated = false;
    clearTooltips();
}
function setModalClosedEvent(callback) {
    $(".modal").on("hidden.bs.modal", callback && isFunction(callback) ? callback : onModalHidden);
}

function formatToCurrency(element) {
    var value = element.value.replaceAll(",", "");
    if (!isNullOrWhiteSpace(value)) {
        value = value.formatMoney(0, false);
    }
    $(element).val(value);
    $(element).attr("value", value);
}
function setTagMoney() {
    $(".tagMoney").toArray().forEach(function (element) {
        formatToCurrency(element);
        $(element).on("keyup", function (event) {
            this.value = this.value.replaceAll(",", "");//replace(/[\$\,]/g, "");
            if (event.key === "-" && parseInt(this.value) > 0) {
                this.value = "-" + this.value;
            }
            if (this.value.isNumber()) {
                formatToCurrency(this);
            }
        });
    });
}
function setAutoSaveLabels(obj) {
    if (!exists(obj)) return;
    $(obj.selector).bootstrapToggle({
        on: isNullOrWhiteSpace(obj.onIcon) ? obj.onLabel : obj.onIcon + obj.onLabel,
        off: isNullOrWhiteSpace(obj.offIcon) ? obj.offLabel : obj.offIcon + obj.offLabel
    })
        .bootstrapToggle(obj.checked ? "on" : "off")
        .bootstrapToggle(obj.enabled ? "enable" : "disable")
        .attr("type", "checkbox")
        .show()
        .change(function () {
            if (isFunction(obj.callback)) {
                obj.callback();
            }
        });
}
function InitMaster() {
    if (window.hasOwnProperty("InitDefaultMasterVars")) {
        window.InitDefaultMasterVars();
    }
}
function $$(id, context) {
    var el = $("#" + id, context);
    if (el.length < 1)
        el = $("[id$=_" + id + "]", context);
    return el;
};
function getAjaxUrl(method) {
    return string.format("{0}{1}", webserviceurl, method);
}
function ajaxSubmit(url, jsonData, successCallback, errorCallback, async, type) {
    /// <summary>
    /// Ajaxes the submit. This method now returns the AJAX promise to allow asyncronous calling of
    /// multiple AJAX submits on a page then waiting for them to come back in a ".when" then doing the appropriate work on the ending calls.
    /// </summary>
    /// <param name="url">The URL.</param>
    /// <param name="jsonData">The json data.</param>
    /// <param name="successCallback">The success callback.</param>
    /// <param name="errorCallback">The error callback.</param>
    /// <param name="async">The asynchronous.</param>
    /// <param name="type">The type.</param>
    /// <returns></returns>

    if (!type) { type = "POST"; }
    return $.ajax({
        type: type,
        url: url,
        data: jsonData,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        processdata: true,
        async: async == undefined ? true : async,
        success: successCallback,
        error: errorCallback ? errorCallback : function (request, status, error) {
            //alert for now we need to move to Modal
            if (typeof request.responseText != "undefined" && request.responseText != null && request.responseText != "") {
                ShowError(request.responseText);
            }
        }

    });
};
function ajaxSubmitDeferred(method, data, callback) {
    return deferredAjax(method, data, callback);
};
function deferredAjax(method, data, callback) {
    return $.when(executeDeferredAjax(method, data)).then(callback);
}
function executeDeferredAjax(method, data) {
    var d = $.Deferred();
    ajaxSubmit(webserviceurl + method, data, function (result) {
        d.resolve(result);
    }, function (error, errorType, message) {
        ShowError(message + "\n" + error);
        d.reject(message + "\n" + error);
    });
    return d.promise();
}
$(document).ajaxSend(function (event, jqxhr, settings) {
    ajaxCalls.push(jqxhr);
});
$(document).ajaxComplete(function (event, jqxhr, settings) {
    var i;
    if ((i = $.inArray(jqxhr, ajaxCalls)) > -1) {
        ajaxCalls.splice(i, 1);
    }
});
function ajaxAbort() {
    /// <summary>
    /// Abort AJAX calls.
    /// </summary>
    /// <returns></returns>
    for (var i = 0; i < ajaxCalls.length; i++) {
        ajaxCalls[i].abort();
    }
};

function ContactUs(id) {
    if ($("#divContactUs").is(":visible")) return;
    ajaxSubmit(webserviceurl + "GetHelpText", $.toJSON({ helpId: id }), function (msg) {
        msg = $.parseJSON(msg.d);
        if (msg.Success) {
            $("#divContactUs").html(msg.Result);
        } else {
            ShowError(msg.Result);
        }
    });
};

function loadOrdersByVendorId() {
    var suffix = $("#" + $$("hdnVendorSuffix_Master").attr("id")).val();
    if (suffix === "VM") {
        var vendorid = $("#" + $$("hdnVendorId_Master").attr("id")).val();
        var jsonText = $.toJSON({ vendorId: vendorid, transactionId: $("#" + window.dm_ViewId).val() });
        ajaxSubmit(String.format("{0}GetOrdersByVendorId", webserviceurl), jsonText,
            function (msg) {
                msg = $.parseJSON(msg.d);
                $("#" + window.dm_ViewId).val(msg.TransactionId);
                if (msg.Success === true) {
                    var data = exists(msg.Data) ? msg.Data : [];

                    data = data.where(function (x) { return !exists(x.OrderCompletedDate) && x.ShowOnOrderWIP && x.AssignmentStatus !== 2; });

                    var conditionalAcceptanceFilterString = "Conditional Acceptance"
                    var newOrders = data.where(function (x) { return !x.Accepted && !x.BatchClient && x.WorkQueueStatus != conditionalAcceptanceFilterString; });// && x.WorkQueueStatus === "Sent To Vendor"; });
                    var inProcessOrders = data.where(function (x) { return x.Accepted && !x.BatchClient && x.WorkQueueStatus === "Vendor Accepted"; });
                    var newOrdersBatch = data.where(function (x) { return !x.Accepted && x.BatchClient && x.WorkQueueStatus != conditionalAcceptanceFilterString; });// && x.WorkQueueStatus === "Sent To Vendor"; });
                    var inProcessOrdersBatch = data.where(function (x) { return x.Accepted && x.BatchClient && x.WorkQueueStatus === "Vendor Accepted"; });
                    conditionalAcceptanceOrders = data.where(function (x) { return !x.Accepted && !x.BatchClient && x.WorkQueueStatus === conditionalAcceptanceFilterString; })
                    conditionalAcceptanceBatchOrders = data.where(function (x) { return !x.Accepted && x.BatchClient && x.WorkQueueStatus === conditionalAcceptanceFilterString;; });

                    $("#" + $$("lblNewOrdersBadgeCount").attr("id")).text(newOrders.length);
                    //$("#" + $$("lblInProcessOrdersBadgeCount").attr("id")).text(inProcessOrders.length);
                    $("#" + $$("lblNewBatchOrderBadgeCount").attr("id")).text(newOrdersBatch.length);
                    //$("#" + $$("lblInProcessBatchOrderBadgeCount").attr("id")).text(inProcessOrdersBatch.length);
                    $("#" + $$("lblConditionalAcceptanceBadgeCount").attr("id")).text(conditionalAcceptanceOrders.length);
                    $("#" + $$("lblConditionalAcceptanceBatchOrderBadgeCount").attr("id")).text(conditionalAcceptanceBatchOrders.length);
                }
            });
    }
};

function loadDashboardBadges() {
    var suffix = $("#" + $$("hdnVendorSuffix_Master").attr("id")).val();
    if (suffix === "VM") {
        var jsonText = $.toJSON({
            transactionId: $("#" + window.dm_ViewId).val()
        });
        ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/LoadVNDashboard",
            jsonText,
            function (msg) {
                msg = $.parseJSON(msg.d);
                $("#" + window.dm_ViewId).val(msg.TransactionId);
                if (msg.Success !== true) {
                    ShowError(msg.Result);
                    return false;
                }

                var newOrders = [];
                var allInProcessOrders = [];
                var inProcessOrders = [];
                var inProcessBatchOrders = [];
                var ordersPastDue = [];
                var ordersDueToday = [];
                var inspectedOrders = [];
                var allInspectionPendingOrders = [];
                var now = moment().format("MM/DD/YYYY");

                if (msg.Data !== null) {
                    newOrders = msg.Data.ResultSet;
                    allInProcessOrders = msg.Data.ResultSet2;
                    allInspectionPendingOrders = msg.Data.ResultSet3;
                }

                var qcCorrectionFilterString = "Appraisal QC correction requested"
                if (allInProcessOrders.any()) {
                    inProcessOrders = allInProcessOrders.where(function (x) { return exists(x) && !x.BatchClient && x.OrderStatus != qcCorrectionFilterString; });
                    inProcessBatchOrders = allInProcessOrders.where(function (x) { return exists(x) && x.BatchClient && x.OrderStatus != qcCorrectionFilterString; });
                    revisionOrders = allInProcessOrders.where(function (x) { return exists(x) && !x.BatchClient && x.OrderStatus == qcCorrectionFilterString; });
                    revisionBatchOrders = allInProcessOrders.where(function (x) { return exists(x) && x.BatchClient && x.OrderStatus == qcCorrectionFilterString; });
                    $("#" + $$("lblInProcessOrdersBadgeCount").attr("id")).text(inProcessOrders.length);
                    $("#" + $$("lblInProcessBatchOrderBadgeCount").attr("id")).text(inProcessBatchOrders.length);
                    $("#" + $$("lblRevisionBadgeCount").attr("id")).text(revisionOrders.length);
                    $("#" + $$("lblRevisionBatchOrderBadgeCount").attr("id")).text(revisionBatchOrders.length);
                }

                if (allInspectionPendingOrders.any()) {
                    inspectionPendingOrders = allInspectionPendingOrders.where(function (x) { return exists(x) && !x.BatchClient });
                    inspectionPendingBatchOrders = allInspectionPendingOrders.where(function (x) { return exists(x) && x.BatchClient });
                    $("#" + $$("lblInspectionPendingBadgeCount").attr("id")).text(inspectionPendingOrders.length);
                    $("#" + $$("lblInspectionPendingBatchOrderBadgeCount").attr("id")).text(inspectionPendingBatchOrders.length);
                }


                return true;
            });
    }
};

function useCommonTooltips(datacontainer, tooltipInnerClass = "") {
    $("*[title],*[data-title],*[data-original-title]").each(function () {
        var self = $(this);
        var placement = isNullOrWhiteSpace(self.attr("data-tooltip-placement")) ? "top" : self.attr("data-tooltip-placement");
        if (self.attr("data-toggle")) {
            self.tooltip({
                placement: placement,
                /*, boundary: "window"*/
                template: string.format("<div class='tooltip' role='tooltip'><div class='arrow'></div><div class='tooltip-inner {0}'></div></div>", tooltipInnerClass)
            });
        } else {
            self.attr("data-toggle", "tooltip")
                .attr("data-html", "true")
                .attr("data-template", string.format("<div class='tooltip' role='tooltip'><div class='arrow'></div><div class='tooltip-inner {0}'></div></div>", tooltipInnerClass))
                .attr("data-placement", placement);
        }
        if (datacontainer) {
            /*******************************************************************************************************
             * Appends the tooltip to a specific element.
             * Example: container: 'body'.
             * This option is particularly useful in that it allows you to position
             * the tooltip in the flow of the document near the triggering element -
             * which will prevent the tooltip from floating away from the triggering element during a window resize.
             * (Source: https://getbootstrap.com/docs/4.3/components/tooltips/)
             *******************************************************************************************************/
            self.attr("data-container", datacontainer);
        }
    });
};

function clearTooltips() {
    setTimeout(function () { $("*").tooltip("hide"); }, 0);
};
function numbersOnly(event) {
    var legalKeyCode = (!event.shiftKey && !event.ctrlKey && !event.altKey) && (jQuery.inArray(event.keyCode, allowedSpecialCharKeyCodes) >= 0 || jQuery.inArray(event.keyCode, numberKeyCodes) >= 0);
    if (stringToBoolean(event.target.dataset.allowpaste)) {
        legalKeyCode = true;
    }
    if (event.shiftKey && event.which === 9) {
        legalKeyCode = true;
    }
    if (event.target.dataset.targetid && event.target instanceof HTMLInputElement && event.which === 13) {
        getDomElementById(event.target.dataset.targetid).trigger('click');
        event.target.blur();
    }
    if (!legalKeyCode) {
        event.preventDefault();
    }
};
function registerNumericTextboxKeydownHandler(callback) {
    setTimeout(_ => {
        if (callback) {
            $("input[type=text].numeric").off("keydown", callback).on("keydown", callback);
        } else {
            $("input[type=text].numeric").off("keydown", numbersOnly).on("keydown", numbersOnly);
        }
    }, 100);
};
function numbersDollarSignOnly(event) {
    /// <summary>
    /// Number only.
    /// </summary>
    /// <param name="event">The event.</param>
    /// <returns></returns>
    var legalKeyCode =
        (!event.shiftKey && !event.ctrlKey && !event.altKey)
        &&
        (jQuery.inArray(event.keyCode, allowedSpecialCharKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, numberKeyCodes) >= 0);

    if (event.shiftKey === true && event.which === 9) {
        legalKeyCode = true;
    }

    // Allow for $
    if (!legalKeyCode && event.shiftKey && event.keyCode == 52)
        legalKeyCode = true;

    if (legalKeyCode === false)
        event.preventDefault();
};

function validEnteredYear(event) {
    /// <summary>
    /// Number only, allow the ~ key.
    /// </summary>
    /// <param name="event">The event.</param>
    /// <returns></returns>
    var legalKeyCode =
        (!event.shiftKey && !event.ctrlKey && !event.altKey)
        &&
        (jQuery.inArray(event.keyCode, allowedSpecialCharKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, numberKeyCodes) >= 0);


    if (event.shiftKey === true && event.which === 192) {
        legalKeyCode = true;
    }

    if (legalKeyCode === false)
        event.preventDefault();
};

function numbersAndCommasOnly(event) {
    /// <summary>
    /// Numbers and commas only.
    /// </summary>
    /// <param name="event">The event.</param>
    /// <returns></returns>
    var legalKeyCode =
        (!event.shiftKey && !event.ctrlKey && !event.altKey)
        &&
        (jQuery.inArray(event.keyCode, allowedSpecialCharKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, numberKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, commaKeyCode) >= 0);


    if (event.shiftKey === true && event.which === 9) {
        legalKeyCode = true;
    }

    if (legalKeyCode === false)
        event.preventDefault();
};

function decimalsOnly(event) {
    /// <summary>
    /// Decimals only.
    /// </summary>
    /// <param name="event">The event.</param>
    /// <returns></returns>
    var legalKeyCode =
        (!event.shiftKey && !event.ctrlKey && !event.altKey)
        &&
        (jQuery.inArray(event.keyCode, allowedSpecialCharKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, numberKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, commaKeyCode) >= 0
            ||
            jQuery.inArray(event.keyCode, decimalKeyCode) >= 0);

    if (event.shiftKey === true && event.which === 9) {
        legalKeyCode = true;
    }

    if (legalKeyCode === false)
        event.preventDefault();
};

function numericDecimalOnly(event) {
    /// <summary>
    /// Numbers and Decimals only. Only allow one decimal to be entered
    /// </summary>
    /// <param name="event">The event.</param>
    /// <returns></returns>

    if (event.shiftKey == true) {
        if (event.which !== 9) {
            event.preventDefault();
        }
    }

    if ((event.keyCode >= 48 && event.keyCode <= 57) ||
        (event.keyCode >= 96 && event.keyCode <= 105) ||
        event.keyCode == 8 || event.keyCode == 9 || event.keyCode == 37 ||
        event.keyCode == 39 || event.keyCode == 46 || event.keyCode == 190 || event.keyCode == 110) {
    } else {
        event.preventDefault();
    }

    if ($(this).val().indexOf(".") !== -1 && event.keyCode == 190)
        event.preventDefault();
}

function currenciesOnly(event) {
    /// <summary>
    /// Currencies only.
    /// </summary>
    /// <param name="event">The event.</param>
    /// <returns></returns>
    var legalKeyCode =
        (!event.shiftKey && !event.ctrlKey && !event.altKey)
        &&
        (jQuery.inArray(event.keyCode, allowedSpecialCharKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, numberKeyCodes) >= 0
            ||
            jQuery.inArray(event.keyCode, commaKeyCode) >= 0
            ||
            jQuery.inArray(event.keyCode, decimalKeyCode) >= 0);

    // Allow for $
    if (!legalKeyCode && event.shiftKey && event.keyCode == 52)
        legalKeyCode = true;

    if ($(this).val().indexOf(".") !== -1 && event.keyCode == 190)
        event.preventDefault();

    if (event.shiftKey === true && event.which === 9) {
        legalKeyCode = true;
    }

    if (legalKeyCode === false)
        event.preventDefault();
};

function toAlphaNumeric(str) {
    /// <summary>
    /// To the alpha numeric.
    /// </summary>
    /// <param name="str">The string.</param>
    /// <returns></returns>
    return str.replace(/[^a-zA-Z 0-9]+/g, "");
};

function htmlEscape(str) {
    /// <summary>
    /// HTML escape.
    /// </summary>
    /// <param name="str">The string.</param>
    /// <returns></returns>
    return String(str)
        .replace(/&/g, "&amp;")
        .replace(/"/g, "&quot;")
        .replace(/'/g, "&#39;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;");
};

function multiLineHtmlEncode(value) {
    /// <summary>
    /// Multi line HTML encode.
    /// </summary>
    /// <param name="value">The value.</param>
    /// <returns></returns>
    var lines = value.split(/\r\n|\r|\n/);
    for (var i = 0; i < lines.length; i++) {
        lines[i] = htmlEncode(lines[i]);
    }
    return lines.join("\r\n");
};

function htmlEncode(value) {
    /// <summary>
    /// HTML encode.
    /// </summary>
    /// <param name="value">The value.</param>
    /// <returns></returns>
    if (value) {
        return jQuery("<div/>").text(value).html();
    } else {
        return "";
    }
};

function htmlDecode(value) {
    /// <summary>
    /// HTML decode.
    /// </summary>
    /// <param name="value">The value.</param>
    /// <returns></returns>
    return (typeof value === "undefined") ? "" : $("<div/>").html(value).text();
};

if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (elt /*, from*/) {
        var len = this.length;

        var from = Number(arguments[1]) || 0;
        from = (from < 0)
            ? Math.ceil(from)
            : Math.floor(from);
        if (from < 0)
            from += len;

        for (; from < len; from++) {
            if (from in this &&
                this[from] === elt)
                return from;
        }
        return -1;
    };
};

function GetAllSelectedItems(ctl, delimiter) {
    /// <summary>
    /// Gets all selected items.
    /// </summary>
    /// <param name="ctl">The control.</param>
    /// <param name="delimiter">The delimiter.</param>
    /// <returns></returns>
    var str = "";

    ctl.find("option:selected").each(function () {
        str += $(this).val() + delimiter;
    });

    return str;

};

function GetFormattedDate(dateVal) {
    /// <summary>
    /// Gets the formatted date.
    /// </summary>
    /// <param name="dateVal">The date value.</param>
    /// <returns></returns>
    if (dateVal)
        //return (new Date(parseInt(dateVal.replace("/Date(", "").replace(")/", ""), 10))).toString("M/d/yyyy");
        return (new Date(dateVal)).toString("yyyy/M/d");
    else
        return "";
};

function SetFormattedDate(dt) {
    /// <summary>
    /// Gets the formatted date.
    /// </summary>
    /// <param name="dateVal">The date value.</param>
    /// <returns></returns>

    if (String.isNullOrWhiteSpace(dt)) {
        return "";
    }

    if (dt) {
        if (dt === "01/01/0001 00:00:00") {
            return "";//default date returned from middle tier, so we assume there is none
        } else {
            var date = new Date(dt);
            return (date.getMonth() + 1) + '/' + date.getDate() + '/' + date.getFullYear();
        }
    }
    else
        return "";
};

function convertDate(inputFormat) {
    /// <summary>
    /// Converts the date.
    /// </summary>
    /// <param name="inputFormat">The input format.</param>
    /// <returns></returns>
    function pad(s) { return (s < 10) ? "0" + s : s; }
    var d = new Date(inputFormat);
    return [pad(d.getMonth() + 1), pad(d.getDate()), d.getFullYear()].join("/");
};

function getQueryString() {
    /// <summary>
    /// Gets the query string.
    /// </summary>
    /// <returns></returns>
    var result = {}, queryString = location.search.substring(1),
        re = /([^&=]+)=([^&]*)/g, m;

    while (m = re.exec(queryString)) {
        result[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
    }

    return result;
};

function GetBacktoServer() {
    /// <summary>
    /// Get back to the server.
    /// </summary>
    /// <returns></returns>
    str = window.location.pathname;
    index = str.lastIndexOf("/");
    page = str.substr(index + 1, str.length - index);
    data = readCookie("history");
    if (data.toLowerCase() != page.toLowerCase())
        window.location.reload();
};

function toTitleCase(str) {
    if (str === null || str === undefined) {
        return "";
    }
    return str.replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase(); });
}

function readCookie(name) {
    /// <summary>
    /// Reads the cookie.
    /// </summary>
    /// <param name="name">The name.</param>
    /// <returns></returns>
    var nameEQ = name + "=";
    var ca = document.cookie.split(";");
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == " ") c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
    }

    return null;
};

function unformatCurrency(num) {
    return exists(num) ? num.toString().replace(/\$|\,/g, "") : "0";
};

function formatCurrency(num, defaultValue, addCurrency, withDecimalPoint = true) {
    /// <summary>
    /// Formats the currency.
    /// </summary>
    /// <param name="num">The number.</param>
    /// <param name="defaultValue">The default value.</param>
    /// <param name="addCurrency">The add currency.</param>
    /// <returns>Formatted money string</returns>

    if (!num || num == undefined) {
        num = 0;
    }

    if (defaultValue == undefined) {
        defaultValue = true;
    }

    if (addCurrency == undefined) {
        addCurrency = true;
    }

    num = num.toString().replace(/\$|\,/g, "");
    if (num == "" || isNaN(num)) {
        if (defaultValue) {
            num = "0";
        } else {
            num = "";
        }
    }
    sign = (num == (num = Math.abs(num)));
    num = Math.floor(num * 100 + 0.50000000001);
    cents = num % 100;
    num = Math.floor(num / 100).toString();
    if (cents < 10) cents = "0" + cents;
    for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++) {
        num = num.substring(0, num.length - (4 * i + 3)) + "," + num.substring(num.length - (4 * i + 3));
    }

    if (num) {
        if (addCurrency) {
            return "$" + (((sign) ? "" : "-") + num + (withDecimalPoint ? "." + cents : ""));
        } else {
            return (((sign) ? "" : "-") + num + (withDecimalPoint ? "." + cents : ""));
        }
    }

    return "";
};

function formatCurrencyWholeNumber(num, defaultValue) {
    /// <summary>
    /// Formats the currency.
    /// </summary>
    /// <param name="num">The number.</param>
    /// <param name="defaultValue">The default value.</param>
    /// <param name="addCurrency">The add currency.</param>
    /// <returns>Formatted money string</returns>

    if (!num || num == undefined) {
        num = 0;
    }

    if (defaultValue == undefined) {
        defaultValue = true;
    }

    num = num.toString().replace(/\.00$|\,/g, "");
    num = num.toString().replace(/\$|\,/g, "");

    if (num == "" || isNaN(num)) {
        if (defaultValue) {
            num = "0";
        } else {
            num = "";
        }
    }

    if (parseInt(num) > 0 || parseInt(num) === 0) {
        num = num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        return "$" + num;
    } else {
        return '';
    }

};

function trim(stringToTrim) {
    return stringToTrim.replace(/^\s+|\s+$/g, "");
};

function ltrim(stringToTrim) {
    return stringToTrim.replace(/^\s+/, "");
};

function rtrim(stringToTrim) {
    return stringToTrim.replace(/\s+$/, "");
};

function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
};

function ComboSelectedText(combo) {

    var val = combo.find("option[selected]");

    if (val.length == 1) {
        return val.text();
    } else {
        return "";
    }
};

function GetDefaultNumericValue(control, defaultValue) {

    if (defaultValue == undefined)
        defaultValue = true;

    var val = unformatCurrency(control.val());

    if (isNaN(val) == false && val != "") {
        return val;
    }

    if (defaultValue) {
        return "0";
    } else {
        return "";
    }
};

function ShowError(msg) {
    /// <summary>
    /// Shows the error.
    /// </summary>
    /// <param name="msg">The MSG.</param>
    /// <returns></returns>
    $("#divErrorBody").css("font-size", "15px").html(msg);
    $("#divError").css('z-index', '2000');//show the error message on top
    $("#divError").modal("show");

    if ($(".close").length != null && $(".close").length != undefined && $(".close").length != 0) { $(".close").focus(); }
};
function showSaveError(msg) {
    if (isNullOrWhiteSpace(msg)) {
        msg = "There was an error saving the data. Please try again later.";
    }
    ShowError(msg);
};

function ShowWait(msg, title) {
    /// <summary>
    /// Shows the error.
    /// </summary>
    /// <param name="msg">The MSG.</param>
    /// <returns></returns>

    $("#divWaitProcessingTitle").html(title);
    $("#divWaitProcessingMessageText").html(msg);
    $("#divWaitProcessing").modal("show");

    if ($(".close").length != null && $(".close").length != undefined && $(".close").length != 0) { $(".close").focus(); }
};

function HideWait() {
    /// <summary>
    /// Shows the error.
    /// </summary>
    /// <param name="msg">The MSG.</param>
    /// <returns></returns>
    $("#divWaitProcessing").modal("hide");
};

function ShowInfo(msg) {
    /// <summary>
    /// Shows the warning.
    /// </summary>
    /// <param name="msg">The MSG.</param>
    /// <returns></returns>
    $("#divInfoBody").html(msg);
    $("#divInfo").modal("show");

    if ($(".close").length != null && $(".close").length != undefined && $(".close").length != 0) { $(".close").focus(); }
};

function formatToDateTime(date) {
    if (date == undefined || date === "") {
        return "";
    }
    var enteredDate = new Date(date).toString("MM/dd/yyyy");
    var enteredDateres = enteredDate.split(" ");
    var month = getMonth(enteredDate);
    var formattedDate = month + "/" + enteredDateres[2] + "/" + enteredDateres[3];
    return formattedDate;
};

function getMonth(monthStr) {
    var strMonth = (new Date(monthStr).getMonth() + 1).toString();
    if (strMonth.length < 2) {
        strMonth = "0" + strMonth;
    }
    return strMonth;
};

function isValidDate(checkString) {
    if (Date.parse(checkString)) {
        return true;
    }
    return false;
};

function ActivateProperMenu() {
    var pagename = $("#" + $$("pagename").attr("id")).val();
    if (typeof pagename != "undefined" && pagename != null) {
        switch (pagename.toLowerCase()) {
            case "messages/inbox":
                if (_suffix === "IU") { setAllMessageFolderBadgeCount(); }
                $("#limessages").addClass("treeview active");
                $("#menumessagefolders").addClass("treeview-menu menu-open");
                $("#messagesangleicon").removeClass("fa-angle-right").addClass("fa-angle-down");
                var folderId = getQueryValueByName("id");
                if (!isNullOrWhiteSpace(folderId)) {
                    if (folderId === "1") {
                        $(string.format("#mfFolderIcon_{0}", folderId)).removeClass("fa-folder").addClass("fa-folder-open");
                    } else {
                        $(string.format("#mfFolderIcon_{0}", folderId)).removeClass("fa-folder").addClass("fa-folder-open");
                    }
                    var obj = JSON.parse(valueOrText("hdnMessageFolders"));
                    var first = obj.firstOrDefault(function (x) { return x.Id === intOrDefault(folderId); });
                    if (!exists(first)) {
                        var pFirst = obj.firstOrDefault(function (x) { return x.Children.any(function (c) { return c.Id === intOrDefault(folderId); }) });
                        if (pFirst) {
                            first = pFirst.Children.firstOrDefault(function (c) { return c.Id === intOrDefault(folderId); });
                        }
                    }
                    if (first) {
                        getDomElementById("PageHeader").text(string.format("{0} - {1}", valueOrText("PageHeader"), first.Name));
                        //
                        $(string.format("#mfcFolderIcon_{0}", folderId)).removeClass("fa-folder-o").addClass("fa-folder-open-o");
                        //
                        toggleSubfolders(first.ParentId);
                    }
                }
                break;
            case "ordertracking/orderresults":
            case "ordertracking/orderentry":
            case "ordertracking/vendorassignmentcompliance":
                $("#liordertracking").removeClass("treeview").addClass("treeview active");
                $("#menuordertracking").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                break;
            case "ordertracking/workqueues":
                $("#liordertracking").removeClass("treeview").addClass("treeview active");
                $("#ctl00_liworkqueues").removeClass("treeview").addClass("treeview active");
                $("#menuordertracking").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                $("#menuworkqueues").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                $("#menubranchworkqueues").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                break;
            case "clientmaintenance/clientadmin":
            case "clientmaintenance/clientprofile":
                $("#liclientMaintenance").removeClass("treeview").addClass("treeview active");
                $("#liclientAdmin").removeClass("treeview").addClass("treeview active");
                $("#menuclientMaintenance").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                $("#menuclientAdmin").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                break;
            case "vendormaintenance/vendormaintenance":
            case "vendormaintenance/vendorsummary":
            case "vendormaintenance/automatedassignmentmaintenance":
                $("#livendormaintenance").removeClass("treeview").addClass("treeview active");
                $("#menuvendormaintenance").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                break;
            case "vendormaintenance/vendorpaneladmin":
            case "vendormaintenance/vendoradd":
            case "vendormaintenance/vendorprofile":
            case "vendormaintenance/vendorpreferenceacceptance":
            case "vendormaintenance/vendorhistory":
            case "vendormaintenance/vendorscoreconfig":
                $("#livendormaintenance").removeClass("treeview").addClass("treeview active");
                $("#livendorpanel").removeClass("treeview").addClass("treeview active");
                $("#menuvendormaintenance").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                $("#menuvendorpanel").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                break;
            case "administration/accountmaintenance":
            case "administration/workqueues":
            case "administration/teamassignment":
            case "administration/branchteams":
            case "administration/messagefoldersmaintenance":
            case "administration/messagerulesmaintenance":
                $("#liadministration").removeClass("treeview").addClass("treeview active");
                $("#menuadministration").removeClass("treeview-menu").addClass("treeview-menu menu-open");
                break;
        }
    }
    getDomElementById("hdnMessageFolders").val("");
};
function toggleMessageFolders(event) {
    event.preventDefault();
    var angleElement = $(event.target);
    var folderId = intOrDefault(angleElement.parent().data("folderid"));
    if (folderId > 0) {
        toggleSubfolders(folderId);
    } else {
        //
        var targetId = event.target.id;
        $("#otsidebarmenu ul.treeview-menu.menu-open:not(#menumessagefolders)").slideToggle(200).removeClass("menu-open");
        $("#otsidebarmenu li.treeview.active:not(#limessages)").removeClass("active");
        //
        $("#menumessagefolders").slideToggle(100).toggleClass("menu-open");
        $("#limessages").toggleClass("active");
        $("#messagesangleicon").toggleClass("fa-angle-right fa-angle-down");
        if (_suffix === "IU" && $("#limessages #menumessagefolders > li > a > span.badge > i.fa-spinner.fa-spin").length > 0) {
            setAllMessageFolderBadgeCount();
        }
        //
        var liparent = getDomElementsById(targetId).closest("li");
        liparent.find("div[id*='messagesanglechilldicon']").removeClass("fa-angle-down").addClass("fa-angle-right");
        liparent.find("ul[data-id='menumessagefolderschildren']").removeClass("menu-open");
    }
};
function toggleSubfolders(folderId) {
    var angleElement = $(string.format("#mfBadgeCount_{0}", folderId)).next();
    var ul = $(string.format("#mfcUL_{0}", folderId));
    var wasOpened = angleElement.hasClass("fa-angle-down");
    $("ul[id^='mfcUL_']").hide(200).removeClass("menu-open");
    $(".mfc-fa-angle").removeClass("fa-angle-down").addClass("fa-angle-right");
    if (wasOpened) {
        ul.addClass("menu-open");
        angleElement.removeClass("fa-angle-down margin-r8").addClass("fa-angle-right");
    } else {
        ul.slideToggle(100).removeClass("menu-open");
        angleElement.addClass("fa-angle-down margin-r8").removeClass("fa-angle-right");
    }
}

function phoneNumberFormating(objId) {
    /// <summary>
    /// Phone number the formating.  This works on blur event.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns>Returns an phone number formatted string no matter what and how you type will be formatted to 111-111-1111</returns>
    var obj = document.getElementById(objId);

    var val = obj.value;

    obj.value = val.replace(/\(/g, "").replace(/\)/g, "").replace(/\+/g, "").replace(/^(\d{3}[-\s.]?)(\d{3}[-\s.]?)(\d{4})([\w\s\d]*)$/g, "$1-$2-$3 $4").replace(/--/g, "-").replace(/\s+/g, " ");
};

function ssnFormating(objId) {
    /// <summary>
    /// SSNs the formating.  This works on keyup event.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns>Returns an SSN formatted string no matter what and how you type will be formatted to 111-11-1111</returns>
    var obj = typeof objId == "string" ? document.getElementById(objId) : objId;

    var val = obj.value.replace(/\D/g, "");
    var newVal = "";
    if (val.length > 4) {
        obj.value = val;
    }
    if ((val.length > 3) && (val.length < 6)) {
        newVal += val.substr(0, 3) + "-";
        val = val.substr(3);
    }
    if (val.length > 5) {
        newVal += val.substr(0, 3) + "-";
        newVal += val.substr(3, 2) + "-";
        val = val.substr(5);
    }
    newVal += val;
    obj.value = newVal;
    if ($("#" + objId).val().length > 11) {
        var currentValue = $("#" + objId).val();
        $("#" + objId).val(currentValue.substring(0, 11));
    }
};

function einFormating(objId) {
    /// <summary>
    /// Eins the formating.  This works on keyup event.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns>Returns an EIN formatted string no matter what and how you type  will be formatted to 11-1111111</returns>
    var obj = typeof objId == "string" ? document.getElementById(objId) : objId;

    var val = obj.value.replace(/\D/g, "");
    var newVal = "";
    if (val.length > 3) {
        obj.value = val;
    }
    if ((val.length > 2) && (val.length < 11)) {
        newVal += val.substr(0, 2) + "-";
        val = val.substr(2);
    }
    if (val.length > 10) {
        newVal += val.substr(0, 2) + "-";
        val = val.substr(2);
    }
    newVal += val;
    obj.value = newVal;
    if ($("#" + objId).val().length > 10) {
        var currentValue = $("#" + objId).val();
        $("#" + objId).val(currentValue.substring(0, 10));
    }
};

function validatePhoneNumber(objId) {
    /// <summary>
    /// Validates the Phone Number.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns>A true or false based on reg ex match</returns>
    var obj = typeof objId == "string" ? document.getElementById(objId).value : $(objId).val();
    var phoneNumberRegExp = /^\d{3}-?\d{3}-?\d{4}?[\w\s]*$/;

    return obj == "" ? true : obj.match(phoneNumberRegExp);
};

function validateSSN(objId) {
    /// <summary>
    /// Validates the SSN.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns>A true or false based on reg ex match</returns>
    var obj = typeof objId == "string" ? document.getElementById(objId).value : $(objId).val();
    var ssnRegExp = /^\d{3}-?\d{2}-?\d{4}$/;

    return obj == "" ? true : obj.match(ssnRegExp);
};
function validateEIN(objId) {
    /// <summary>
    /// Validates the ein.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns>A true or false based on reg ex match</returns>
    var obj = typeof objId == "string" ? document.getElementById(objId).value : $(objId).val();
    var einRegExp = /^\d{2}-?\d{7}$/;

    return obj == "" ? true : obj.match(einRegExp);
};

function validateEmail(objId) {
    /// <summary>
    /// Validates the email.
    /// </summary>
    /// <param name="objId">The object identifier.</param>
    /// <returns></returns>
    var obj = typeof objId == "string" ? document.getElementById(objId).value : $(objId).val();
    var emailRegExp = /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;

    return obj == "" ? true : obj.match(emailRegExp);
}

function returnDateTimeWithoutTimezone(dateTime) {
    /// <summary>
    /// Returns the date time without timezone.
    /// </summary>
    /// <param name="dateTime">The date time.</param>
    /// <returns></returns>
    var checkIfDate = dateTime.split(" ");
    if (checkIfDate.length == 4 && isValidDate(checkIfDate[0] + " " + checkIfDate[1] + " " + checkIfDate[2])) {
        var convertedDateTime = "";
        var currentTime = checkIfDate[0] + " " + checkIfDate[1] + " " + checkIfDate[2];
        convertedDateTime = formatAsUserSpecificDate(currentTime, _userTimeZone, _systemTimeZone, "MM/DD/YYYY hh:mm A").split(" ");

        return (convertedDateTime[0] + " " + convertedDateTime[1] + " " + convertedDateTime[2]);
    } else {
        return "";
    }
};

function checkOrderAddress(pageUrl, streetName, city, state, zip) {
    pageUrl = pageUrl.replace(/\&amp;/g, '&');
    if ((streetName === null || streetName === undefined || streetName === "") || (city === null || city === undefined || city === "") ||
        (state === null || state === undefined || state === 0) || (zip === null || zip === undefined || zip === "")) {
        alert("Please make sure full address is entered before GeoCoding.");
    } else {
        OpenPopUp(pageUrl);
    }
}

function OpenPopUp(myUrl) {
    OpenPopupTarget(myUrl, "ValueNetPopUp");
}

function OpenPopupTarget(myUrl, myTarget) {
    var win = window.open(myUrl, myTarget, "left=20,top=20,width=" + (window.screen.width * 80) / 100 + ",height=650,location=0,status=0,scrollbars=1,toolbar=0,menubar=0,resizable=1");
};

function printPage() {
    $("#iconActions").click();
    window.print();
}

function activateStickyHeader(headerSelector, styleSelector) {
    window.onscroll = function () {
        var stickyHeader = document.getElementById(headerSelector);
        var sticky = stickyHeader.offsetTop;
        if (!isMSBrowserFamily()) {
            stickyHeader.style.WebkitTransitionDuration = ".3s";
            stickyHeader.style.transitionDuration = ".3s";
        }
        if (window.pageYOffset > sticky) {
            stickyHeader.classList.add(styleSelector);
        } else {
            stickyHeader.classList.remove(styleSelector);
        }
    };
}
function activateStickyHeaderPlus(arrayObj) {
    window.onscroll = function () {
        $.each(arrayObj, (_, obj) => {
            var stickyElement = document.getElementById(obj.id);
            var offsetTop = stickyElement.offsetTop;
            if (!isMSBrowserFamily()) {
                stickyElement.style.WebkitTransitionDuration = ".3s";
                stickyElement.style.transitionDuration = ".3s";
            }
            if (window.pageYOffset > offsetTop) {
                stickyElement.classList.add(obj.class);
                document.querySelector("html").style["overflow-x"] = "unset";
                document.querySelector(".wrapper").style["overflow"] = "unset";
            } else {
                stickyElement.classList.remove(obj.class);
                document.querySelector("html").style["overflow-x"] = "hidden";
                document.querySelector(".wrapper").style["overflow"] = "hidden";
            }
        });
    };
}
function activateBack2Top() {
    if (getDomElementById("Back2TopHolder").length > 0) {
        window.onscroll = function () {
            let $back2TopHolder = getDomElementById("Back2TopHolder");
            if (window.pageYOffset > (window.innerHeight)) {
                $back2TopHolder.show("slow");
            } else {
                $back2TopHolder.hide("slow");
            }
        };
    }
}

function confirmDeletion(title, message, callBack) {
    bootbox.confirm({
        title: title,
        centerVertical: true,
        message: String.format("<h4 class='text-center' style='line-height: 25px;font-family:auto;'>{0}</h4>", message),
        buttons: {
            "confirm": {
                label: "<i class='fa fa-check'></i> Yes",
                className: "btn btn-primary btn-flat width-100"
            },
            "cancel": {
                label: "<i class='fa fa-remove'></i> No",
                className: "btn btn-default btn-flat width-100"
            }
        },
        callback: function (result) {
            if (result) {
                if ($.isFunction(callBack)) {
                    callBack();
                }
            }
        }
    });
}

function createStatesDropdown(dropdownId, statesNames, exclusionList, withEmptyOption) {
    if (exclusionList && typeof exclusionList === "string") {
        exclusionList = exclusionList.split(",");
    }
    var filteredStateList = exclusionList && exclusionList.any() ? statesNames.where(function (state) { return !exclusionList.contains(state); }) : statesNames;
    var select = String.format("<select id='{0}' class='form-control'>{1}", dropdownId, withEmptyOption ? "<option>Select...</option>" : "");
    $.each(filteredStateList, function (i, state) {
        select += String.format("<option value='{0}'>{0}</option>", state);
    });
    select += "</select>";
    return select;
}


function setMessageFolderBadgeCount(folderId, isParent) {
    if (!exists(folderId)) return;
    var badgeElement = isParent ? string.format("mfBadgeCount_{0}", folderId) : string.format("mfcBadgeCount_{0}", folderId);
    getDomElementById(badgeElement).html('<i class="fa fa-spinner fa-spin white font-8"></i>');
    ajaxSubmit(webserviceurl + "GetMessageCountByFolderId", $.toJSON({ folderId: folderId, viewId: $("#" + window.dm_ViewId).val() }), function (msg) {
        msg = $.parseJSON(msg.d);
        $("#" + window.dm_ViewId).val(msg.TransactionId);
        if (!msg.Success) {
            ShowError("Error loading message folder");
            setAllMessageFolderBadgeCount();
        } else {
            getDomElementById(badgeElement).html(intOrDefault(msg.Result));
        }
    }, function (a, b, c) {
        ShowError("Error loading message folder");
        setAllMessageFolderBadgeCount();
    });
}
function setAllMessageFolderBadgeCount() {
    ajaxSubmit(webserviceurl + "GetAllMessagesCount", $.toJSON({ viewId: $("#" + window.dm_ViewId).val() }), function (msg) {
        msg = $.parseJSON(msg.d);
        $("#" + window.dm_ViewId).val(msg.TransactionId);
        $.each(valueOrText("hdnFolderIds").split(","), function (i, fid) {
            getDomElementById(string.format("mfBadgeCount_{0}", fid)).html(0);
        });
        $("span[id*='mfcBadgeCount']").html(0);
        if (msg.Success) {
            var data = msg.Data ? msg.Data.ResultSet : [];
            if (data.any()) {
                data.forEach(function (record) {
                    if (record.IsParent) {
                        getDomElementById(string.format("mfBadgeCount_{0}", record.MessageFolderId)).html(record.MessageCount);
                    } else {
                        getDomElementById(string.format("mfcBadgeCount_{0}", record.MessageFolderId)).html(record.MessageCount);
                    }
                });
            }
        } else {
            ShowError("Error loading message folders");
        }
        getDomElementById("hdnFolderIds").val("");
    }, function (a, b, c) {
        ShowError("Error loading message folders");
        $.each(valueOrText("hdnFolderIds").split(","), function (j, fid) {
            getDomElementById(string.format("mfBadgeCount_{0}", fid)).html(0);
            $("span[id*='mfcBadgeCount']").html(0);
        });
        getDomElementById("hdnFolderIds").val("");
    });
}

function CloseReviewTab() {
    var lblStatus = $("#" + $$("lblStatus").attr("id")).text()
    if (lblStatus == 'Completed') {
        ReviewToOrderDashboard()
    }
    else {
        window.close();
    }
}

function CloseReviewTabAndRefreshParent() {
    var lblStatus = $("#" + $$("lblStatus").attr("id")).text()
    if (lblStatus == 'Completed') {
        ReviewToOrderDashboard()
    }
    else {
        window.close();
        refreshParentOpener();
    }
}

function openAppraisalReviewWindow(url) {
    window.open(url, '_self');
}

function openOrderDashboardWindow(element, url) {
    if (_orderDataBag.isExternalQC) {
        var rowIndex = $(element).attr("data-row");
        var previousTeamMember = $("#memberrow_" + rowIndex).text();
        var userfullname = getDomElementById("hdnuserfullname").val();

        if (previousTeamMember.toLowerCase() == "unassigned" || previousTeamMember.toLowerCase() != userfullname.toLowerCase()) {
            $("#divOrderNotAssigned").modal("show");
            return false;
        }
    }
    window.open(url, '_blank');
}

function OrderIpcrInspection(OrderNumber, ItemNumber) {
    var jsonText = $.toJSON({
        orderNo: OrderNumber,
        itemNo: ItemNumber,
        transactionId: $("#" + window.dm_TransactionId).val()
    });

    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/OrderIpcrInspection",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                if (msg.Data === 'iPcrOrdered') {//ipcr event already exists
                    commonDialogAlert('An iPCR Inspection has already been ordered.')
                }
                else {
                    Notify("Failed to Order iPCR Inspection", "bottom-right", "5000", "danger", "fa-times", true);
                    ShowError(msg.ErrorMessage);
                    return '';
                }
            }
            else {
                $("#divEditDueDates").modal('hide');
                Notify("iPCR Inspection Ordered Successfully.", "bottom-right", "5000", "success", "fa-check", true);

                var pagename = $("#" + $$("pagename").attr("id")).val();
                if (typeof pagename != "undefined" && pagename != null) {
                    if (pagename.toLowerCase() === 'eventtracking' || pagename.toLowerCase() === 'orderstatus') {
                        window.location.reload();
                    }
                }
            }
        });
}

function RefreshPropMixCompsData(OrderNo) {
    bootbox.confirm({
        title: "Please Confirm",
        message: "By refreshing the data all selected comparables will be cleared in order to refresh all data for subject comparables.  Please confirm you want to refresh the data.",
        buttons: {
            'confirm': {
                label: '<i class="fa fa-check"></i>&nbsp;Yes',
                className: 'btn btn-primary btn-flat'
            },
            'cancel': {
                label: '<i class="fa fa-remove"></i>&nbsp;No',
                className: 'btn btn-default btn-flat'
            }
        },
        callback: function (result) {
            if (result) {
                blurPage("Please wait while the comparable data is refreshed. This may take a minute");
                RefreshPropMixComps(OrderNo);
            }
            return;
        }
    });
}

function RefreshPropMixComps(OrderNo) {
    var jsonText = $.toJSON({ orderNo: OrderNo, transactionId: $("#" + window.dm_TransactionId).val() });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/RefreshPropMixComps",
        jsonText,
        function (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success !== true) {
                ShowError(msg.Result);
                unblurPage();
                return '';
            }
            else {
                toastr.success("The comparables data has been successfully updated.");
                unblurPage();
            }
        });
}

function getOnHoldIndicatorIcon(tooltipPosition, iconColor) {
    if (!tooltipPosition) {
        tooltipPosition = "right";
    }
    if (!iconColor) {
        iconColor = "red";
    }
    return string.format("<span title='DELAY' data-toggle='tooltip' data-placement='{0}'><i class='fa fa-hand-paper-o font-14' style='color: {1} !important;'></i></span>", tooltipPosition, iconColor);
}

function drawerClosed(closeButton) {
    var sourceid = $(closeButton).attr("data-sourceid");
    getDomElementById(sourceid).removeClass("activeSourceDrawer");
    $(closeButton).parent().next().html(string.empty);
    $(closeButton).removeAttr("data-sourceid");
}
function closeBottomDrawer(closeButton, callback) {
    var drawer = $(closeButton).closest("div[id$='DrawerWrapper']");
    drawer.removeClass("bottomDrawerExpanded");
    if (isFunction(callback)) {
        callback(closeButton);
    }
}
function closeRightDrawer(event, callback) {
    var drawer = $(event.target).closest("div[id$='DrawerWrapper']");
    drawer.toggleClass("rigthDrawerExpanded rightDrawerCollapsed", "slow");
    if (isFunction(callback)) {
        callback(event);
    }
}
function copyToClipboard(valueElement, labelElement) {
    clearTooltips();
    $(valueElement).removeAttr("disabled").select();
    document.execCommand("copy");
    $(valueElement).attr("disabled", "disabled");
    Notify('"' + $(labelElement).text() + '" copied to clipboard!', "bottom-right", "2000", "success", "fa-check", true);
}
/* Based of [dbo].[CalcDistanceBetweenLocations]*/
function getDistanceBetweenProperties(prop1Lat, prop1Long, prop2Lat, prop2Long, unit = "M", decimalPoint = 2) {
    if (!decimalPoint || decimalPoint < 0) {
        decimalPoint = 2;
    }
    if (isNullOrWhiteSpace(unit)) {
        unit = "M";// Miles
    }
    unit = unit.toUpperCase();
    if ((prop1Lat == prop2Lat) && (prop1Long == prop2Long)) {
        return 0;
    }
    else {
        if (prop1Lat === 620 || prop2Lat === 620) {
            return 1000;
        }
        var prop1Radlat = Math.PI * prop1Lat / 180;
        var prop2Radlat = Math.PI * prop2Lat / 180;
        var diffLong = prop1Long - prop2Long;
        var radian = Math.PI * diffLong / 180;
        var distance = Math.sin(prop1Radlat) * Math.sin(prop2Radlat) + Math.cos(prop1Radlat) * Math.cos(prop2Radlat) * Math.cos(radian);
        if (distance > 1) {
            distance = 1;
        }
        distance = Math.acos(distance);
        distance = distance * 180 / Math.PI;
        distance = distance * 60 * 1.1515;
        // Kilometers: 1 mile = 1.609344 km
        if (unit == "K") { distance = distance * 1.609344 }
        // Nautical: 1 mile = 0.8684 nauticalp;l
        if (unit == "N") { distance = distance * 0.8684 }
        return distance.toFixed(decimalPoint); // This will round-up the return value
    }
}

function createUadDateOfSale(formattedDateOfSale) {
    var uad = { StatusType: null, SettlementDate: "", ContractDate: "", ContractDateUnknown: formattedDateOfSale.contains("UNK"), IsActive: false };
    var webControlId = formattedDateOfSale.firstChar(1).toLowerCase();
    switch (webControlId) {
        case "a":
            uad.StatusType = "Active";
            uad.IsActive = true;
            break;
        case "c":
            uad.StatusType = "Contract";
            uad.IsActive = true;
            uad.ContractDate = formattedDateOfSale.substr(1);
            break;
        case "e":
            uad.StatusType = "Expired";
            uad.SettlementDate = formattedDateOfSale.substr(1);
            break;
        case "w":
            uad.StatusType = "Withdrawn";
            uad.SettlementDate = formattedDateOfSale.substr(1);
            break;
        case "s":
            uad.StatusType = "Settled sale";
            uad.SettlementDate = formattedDateOfSale.substr(1, 5);
            if (!uad.ContractDateUnknown) {
                uad.ContractDate = formattedDateOfSale.substr(8);
            }
            break;
    }
    return uad;
}
function getUadDateOfSale(uad) {
    if (!exists(uad)) return string.empty;
    var formattedDateOfSale = "";
    switch (uad.StatusType) {
        case "Active":
        case "Pending":
            formattedDateOfSale = "Active";
            break;
        case "Contract":
        case "Active Under Contract":
            formattedDateOfSale = "c".concat(uad.ContractDate);
            break;
        case "Expired":
            formattedDateOfSale = "e".concat(uad.SettlementDate);
            break;
        case "Withdrawn":
            formattedDateOfSale = "w".concat(uad.SettlementDate);
            break;
        case "Settled sale":
        case "Sold":
            if (!string.isNullOrWhiteSpace(uad.SettlementDate)) {
                formattedDateOfSale = "s".concat(uad.SettlementDate, ";");
                if (uad.ContractDateUnknown) {
                    formattedDateOfSale += "UNK";
                } else if (!isNullOrWhiteSpace(uad.ContractDate)) {
                    formattedDateOfSale = formattedDateOfSale.concat("c", uad.ContractDate);
                }
            }
            break;
    }
    return formattedDateOfSale;
}
function getUADGarageValue(appraisalData, acceptEmpty = false) {
    var uadValue = "";
    let iscondo = stringOrDefault(appraisalData.PropType).toLowerCase() === "condo" || stringOrDefault(appraisalData.PropType).toLowerCase() === "condotel";
    if (iscondo) {
        if (appraisalData.PropCondoGarage > 0) {
            uadValue += (appraisalData.PropCondoGarage + "g");
        }
        if (appraisalData.PropCondoCovered > 0) {
            uadValue += (appraisalData.PropCondoCovered + "cv");
        }
        if (appraisalData.PropCondoOpen > 0) {
            uadValue += (appraisalData.PropCondoOpen + "op");
        }
        if (uadValue == "" && ((appraisalData.PropGarageCondoDescription != "" && appraisalData.PropGarageCondoDescription != null) || (appraisalData.PropCondoGarage != null || appraisalData.PropCondoCovered != null || appraisalData.PropCondoOpen != null))) {
            uadValue = "None";
        }
        if (appraisalData.PropGarageCondoDescription !== "" && appraisalData.PropGarageCondoDescription !== null) {
            uadValue += ";" + appraisalData.PropGarageCondoDescription;
        }
    }
    else {
        if (appraisalData.PropGarageSpaces > 0) {
            uadValue += (appraisalData.PropGarageSpaces + "ga");
        }
        if (appraisalData.PropDetachedGarageSpaces > 0) {
            uadValue += (appraisalData.PropDetachedGarageSpaces + "gd");
        }
        if (appraisalData.PropBuiltInGarageSpaces > 0) {
            uadValue += (appraisalData.PropBuiltInGarageSpaces + "gbi");
        }
        if (appraisalData.PropCarportSpaces > 0) {
            uadValue += (appraisalData.PropCarportSpaces + "cp");
        }
        if (appraisalData.PropDrivewaySpaces > 0) {
            uadValue += (appraisalData.PropDrivewaySpaces + "dw");
        }
        if (isNullOrWhiteSpace(uadValue) &&
            (!isNullOrWhiteSpace(appraisalData.PropGarageDescription) ||
                (appraisalData.PropGarageSpaces != null || appraisalData.PropDetachedGarageSpaces != null || appraisalData.PropBuiltInGarageSpaces != null || appraisalData.PropCarportSpaces != null || appraisalData.PropDrivewaySpaces != null))) {
            uadValue = acceptEmpty ? "" : "None";
        }
        if (appraisalData.PropGarageDescription != "" && appraisalData.PropGarageDescription != null) {
            uadValue += ";" + appraisalData.PropGarageDescription;
        }
    }
    return uadValue;
};
function getUADCodedGarageValue(obj) {
    var garageValue = obj.isOffStreetParkingChecked ? "None" : "";
    if (obj.isCondo) {
        if (!obj.isOffStreetParkingChecked) {
            if (obj.garageCondo > 0) {
                garageValue += obj.garageCondo + "g";
            }
            if (obj.coveredCondo > 0) {
                garageValue += obj.coveredCondo + "cv";
            }
            if (obj.openCondo > 0) {
                garageValue += obj.openCondo + "op";
            }
            if (isNullOrWhiteSpace(garageValue)) {
                garageValue = "None";
            }
        }
        if (!isNullOrWhiteSpace(obj.condoDescription)) {
            garageValue += ";" + obj.condoDescription;
        }
    }
    else {
        if (!obj.isOffStreetParkingChecked) {
            if (obj.attachedGarageSpaces > 0) {
                garageValue += (obj.attachedGarageSpaces + "ga");
            }
            if (obj.detachedGarageSpaces > 0) {
                garageValue += (obj.detachedGarageSpaces + "gd");
            }
            if (obj.builtInGarageSpaces > 0) {
                garageValue += (obj.builtInGarageSpaces + "gbi");
            }
            if (obj.carportGarageSpaces > 0) {
                garageValue += (obj.carportGarageSpaces + "cp");
            }
            if (obj.drivewayParkingSpaces > 0) {
                garageValue += (obj.drivewayParkingSpaces + "dw");
            }
            if (isNullOrWhiteSpace(garageValue)) {
                garageValue = "None";
            }
        }
        if (!isNullOrWhiteSpace(obj.garageDescription)) {
            garageValue += ";" + obj.garageDescription;
        }
    }
    return garageValue;
};
function getUADGarageValues(textboxValue, isCondo) {
    var uadValue = {};
    uadValue.offStreetParking = textboxValue.toLowerCase().includes("none");
    //
    uadValue.garageCondo = 0;
    uadValue.coveredCondo = 0;
    uadValue.openCondo = 0;
    uadValue.condoDescription = "";
    //
    uadValue.attachedGarage = 0;
    uadValue.detachedGarage = 0;
    uadValue.builtInGarage = 0;
    uadValue.carpot = 0;
    uadValue.driveway = 0;
    uadValue.additionalDescription = "";
    //
    var values = "";
    var data = removeAllWhiteSpaces(textboxValue.split(";")[0]);
    for (var i = 1; i < data.length; i++) {
        if (data[i].isAlpha()) {
            values += textboxValue[i];
        } else {
            values += ",";
        }
    }
    var list = [];
    $.each(values.split(","), (index, item) => {
        var value = intOrDefault(textboxValue.split(item)[0]);
        list.push({ text: item, value: value });
        textboxValue = textboxValue.replace(value + item, "");
    });
    if (list.any()) {
        var first;
        if (isCondo) {
            first = list.firstOrDefault(function (x) { return x.text === "g"; });
            uadValue.garageCondo = first ? first.value : 0;
            first = list.firstOrDefault(function (x) { return x.text === "cv"; });
            uadValue.coveredCondo = first ? first.value : 0;
            first = list.firstOrDefault(function (x) { return x.text === "op"; });
            uadValue.openCondo = first ? first.value : 0;
        } else {
            first = list.firstOrDefault(function (x) { return x.text === "ga"; });
            uadValue.attachedGarage = first ? first.value : 0;
            first = list.firstOrDefault(function (x) { return x.text === "gd"; });
            uadValue.detachedGarage = first ? intOrDefault(first.value) : 0;
            first = list.firstOrDefault(function (x) { return x.text === "gbi"; });
            uadValue.builtInGarage = first ? first.value : 0;
            first = list.firstOrDefault(function (x) { return x.text === "cp"; });
            uadValue.carpot = first ? first.value : 0;
            first = list.firstOrDefault(function (x) { return x.text === "dw"; });
            uadValue.driveway = first ? first.value : 0;
        }
    }
    var desc = textboxValue.split(";").length > 1 ? textboxValue.split(";")[1] : "";
    if (isCondo) {
        uadValue.condoDescription = desc;
    } else {
        uadValue.additionalDescription = desc;
    }
    return uadValue;
};
function getUADLocationValues(ratings, data, appraisalData) {
    var uadValue = "";
    var others = [];
    var bitMasks = [];
    var ratingBitMask = appraisalData.PropLocationRating;
    if (string.hasContent(appraisalData.PropLocationOther)) {
        others.push(appraisalData.PropLocationOther);
    }
    var first = ratings.firstOrDefault(function (r) { return r.BitMaskValue === appraisalData.PropLocationRating; });
    if (!first) return { ratingBitMask: ratingBitMask, uadValue: uadValue, bitMasks: bitMasks, others: others };
    uadValue = first.WebControlId;
    data.forEach(function (item) {
        var mask = item.BitMaskValue & appraisalData.PropLocation;
        if (mask > 0) {
            var text = item.WebControlId;
            if (text === "any other value") {
                text = others.join("; ");
            }
            uadValue += "; " + text;
            bitMasks.push(item.BitMaskValue);
        }
    });
    return { ratingBitMask: ratingBitMask, uadValue: uadValue, bitMasks: bitMasks, others: others };
};
function getUADViewValues(ratings, data, appraisalData) {
    var uadValue = "";
    var others = [];
    var bitMasks = [];
    var ratingBitMask = appraisalData.PropViewRating;
    if (string.hasContent(appraisalData.PropViewOther)) {
        others.push(appraisalData.PropViewOther);
    }
    var first = ratings.firstOrDefault(function (r) { return r.BitMaskValue === appraisalData.PropViewRating; });
    if (!first) return { ratingBitMask: ratingBitMask, uadValue: uadValue, bitMasks: bitMasks, others: others };
    uadValue = first.WebControlId;
    data.forEach(function (item) {
        var mask = item.BitMaskValue & appraisalData.PropView;
        if (mask > 0) {
            var text = item.WebControlId;
            if (text === "any other value") {
                text = others.join("; ");
            }
            uadValue += "; " + text;
            bitMasks.push(item.BitMaskValue);
        }
    });
    return { ratingBitMask: ratingBitMask, uadValue: uadValue, bitMasks: bitMasks, others: others };
};
function getUADBasementValues(masterBasements, base1Val, base2Val) {
    var totalArea = 0;
    var finishedArea = 0;
    var exitType = 0;
    var recreationRoom = 0;
    var bedroom = 0;
    var fullBathroom = 0;
    var halfBathroom = 0;
    var other = 0;
    if (string.hasContent(base1Val)) {
        var array = base1Val.split("sf");
        totalArea = intOrDefault(array[0]);
        finishedArea = array.length > 1 ? intOrDefault(array[1]) : 0;
        var exit = array.length > 2 ? array[2] : "";
        var first = masterBasements.firstOrDefault(function (r) { return exit === r.WebControlId; });
        if (first) {
            exitType = first.BitMaskValue;
        }
    }
    if (string.hasContent(base2Val)) {
        recreationRoom = intOrDefault(base2Val.split("rr")[0]);
        bedroom = intOrDefault(base2Val.split("br")[0].split("rr")[1]);
        fullBathroom = intOrDefault(base2Val.split("br")[1].split(".")[0]);
        halfBathroom = intOrDefault(base2Val.split("ba")[0].lastChar(1));
        other = intOrDefault(base2Val.lastChar(2).firstChar(1));
    }
    return { totalArea: totalArea, finishedArea: finishedArea, exitType: exitType, recreationRoom: recreationRoom, bedroom: bedroom, fullBathroom: fullBathroom, halfBathroom: halfBathroom, other: other, rawValue1: base1Val, rawValue2: base2Val };
};
function getLocationValue(ratingBitMask, locationBitMask, otherValue) {
    var values = [];
    var locationBitMasks = getLocationBitMasks(locationBitMask);
    switch (ratingBitMask) {
        case 2:
            values.push("N");
            break;
        case 4:
            values.push("B");
            break;
        case 8:
            values.push("A");
            break;
    }
    locationBitMasks.forEach(function (bmv) {
        switch (bmv) {
            case 2:
                values.push("Res");
                break;
            case 4:
                values.push("Ind");
                break;
            case 8:
                values.push("Comm");
                break;
            case 16:
                values.push("BsyRd");
                break;
            case 32:
                values.push("WtrFr");
                break;
            case 64:
                values.push("GlfCse");
                break;
            case 128:
                values.push("AdjPrk");
                break;
            case 256:
                values.push("AdjPwr");
                break;
            case 512:
                values.push("Lndfl");
                break;
            case 1024:
                values.push("PubTrn");
                break;
            case 2048:
                values.push(otherValue);
                break;
        }
    });
    return values.join(";");
};
function getViewValue(ratingBitMask, viewBitMask, otherValue) {
    var values = [];
    var viewBitMasks = getViewBitMasks(viewBitMask);
    switch (ratingBitMask) {
        case 2:
            values.push("N");
            break;
        case 4:
            values.push("B");
            break;
        case 8:
            values.push("A");
            break;
    }
    viewBitMasks.forEach(function (bmv) {
        switch (bmv) {
            case 2:
                values.push("Wtr");
                break;
            case 4:
                values.push("Pstrl");
                break;
            case 8:
                values.push("Woods");
                break;
            case 16:
                values.push("Prk");
                break;
            case 32:
                values.push("Glfvw");
                break;
            case 64:
                values.push("CtySky");
                break;
            case 128:
                values.push("Mtn");
                break;
            case 256:
                values.push("Res");
                break;
            case 512:
                values.push("CtyStr");
                break;
            case 1024:
                values.push("Ind");
                break;
            case 2048:
                values.push("PwrLn");
                break;
            case 4096:
                values.push("LtdSght");
                break;
            case 8192:
                values.push(otherValue);
                break;
        }
    });
    return values.join(";");
};
function getBasementValues(base1Val, base2Val) {
    var totalArea = 0;
    var finishedArea = 0;
    var exitType = 0;
    var recreationRoom = 0;
    var bedroom = 0;
    var fullBathroom = 0;
    var halfBathroom = 0;
    var other = 0;
    if (string.hasContent(base1Val)) {
        var array = base1Val.split("sf");
        totalArea = intOrDefault(array[0]);
        finishedArea = array.length > 1 ? intOrDefault(array[1]) : 0;
        var exit = array.length > 2 ? array[2] : "";
        switch (exit) {
            case "wo":
                exitType = 2;
                break;
            case "wu":
                exitType = 4;
                break;
            case "in":
                exitType = 8;
                break;
        }
    }
    if (string.hasContent(base2Val)) {
        recreationRoom = intOrDefault(base2Val.split("rr")[0]);
        bedroom = intOrDefault(base2Val.split("br")[0].split("rr")[1]);
        fullBathroom = intOrDefault(base2Val.split("br")[1].split(".")[0]);
        halfBathroom = intOrDefault(base2Val.split("ba")[0].lastChar(1));
        other = intOrDefault(base2Val.lastChar(2).firstChar(1));
    }
    return { totalArea: totalArea, finishedArea: finishedArea, exitType: exitType, recreationRoom: recreationRoom, bedroom: bedroom, fullBathroom: fullBathroom, halfBathroom: halfBathroom, other: other, rawValue1: base1Val, rawValue2: base2Val };
};
function getBasementRawValue(basementTotalArea, basementFinishedArea, basementExitType, basementRecreationRoom, basementBedroom, basementFullBathroom, basementHalfBathroom, basementOther) {
    var value = { basementValue: "{0}sf{1}sf{2}", roomBelowGradeValue: "{0}rr{1}br{2}.{3}ba{4}o" };
    if (intOrDefault(basementTotalArea) <= 0) {
        return { basementValue: "0sf", roomBelowGradeValue: "0rr0br0.0ba0o" };
    }
    switch (intOrDefault(basementExitType)) {
        case 2:
            basementExitType = "wo";
            break;
        case 4:
            basementExitType = "wu";
            break;
        case 8:
            basementExitType = "in";
            break;
        default:
            basementExitType = "wo";
            break;
    }
    value.basementValue = string.format(value.basementValue, intOrDefault(basementTotalArea), intOrDefault(basementFinishedArea), basementExitType);
    value.roomBelowGradeValue = string.format(value.roomBelowGradeValue, intOrDefault(basementRecreationRoom), intOrDefault(basementBedroom), intOrDefault(basementFullBathroom), intOrDefault(basementHalfBathroom), intOrDefault(basementOther));
    return value;
}
function setBitMask(masks) {
    var mask = 0;
    if (!exists(masks) || !masks.any()) {
        return 0;
    }
    if (masks.any(function (x) { return !isNumeric(x); })) {
        return 0;
    }
    masks.forEach(item => {
        mask |= item;
    });
    return mask;
}
function getBitMasks(seedMask, masterList) {
    var bitMasks = [];
    if (!exists(masterList) || !masterList.any()) {
        return bitMasks;
    }
    if (masterList.any(function (x) { return !isNumeric(x); })) {
        return 0;
    }
    masterList.forEach(mask => {
        var nodeMask = mask & seedMask;
        if (nodeMask > 0) {
            bitMasks.push(nodeMask);
        }
    });
    return bitMasks;
}
function getRatingBitMasks(seedMask) {
    return getBitMasks(seedMask, [2, 4, 8]);
}
function getLocationBitMasks(seedMask) {
    return getBitMasks(seedMask, [2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048]);
}
function getViewBitMasks(seedMask) {
    return getBitMasks(seedMask, [2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192]);
}
function getBasementBitMasks(seedMask) {
    return getBitMasks(seedMask, [2, 4, 8]);
}
function getHeatingReferenceId(htmlDesc, crossRef) {
    let referenceId = 0;
    let first;
    let heat;
    if (crossRef) {
        first = crossRef.firstOrDefault(function (x) { return x.hasOwnProperty("PropHeatingType"); });
    }
    if (first && isNullOrWhiteSpace(htmlDesc)) {
        heat = first.PropHeatingType.firstOrDefault(function (x) { return x.HTMLDesc === "Other"; });
        if (heat) {
            htmlDesc = heat.HTMLDesc;//"Other"
        }
    }
    if (crossRef && first) {
        heat = first.PropHeatingType.firstOrDefault(function (x) { return x.HTMLDesc === htmlDesc; });
        if (heat) {
            referenceId = heat.ReferenceId;
        }
    } else {
        switch (htmlDesc) {
            case "FWA":
                referenceId = 1;
                break;
            case "HWBB":
                referenceId = 2;
                break;
            case "Radiant":
                referenceId = 3;
                break;
            case "Fuel":
                referenceId = 4;
                break;
            case "Other":
                referenceId = 5;
                break;
        }
    }

    return referenceId;
}
function formatCrossReferenceHeatingTypeValue(refid) {
    refid = intOrDefault(refid);
    let value = "";
    switch (refid) {
        case 1:
            value = _enum.propertyHeatingTypes.fwa.value;
            break;
        case 2:
            value = _enum.propertyHeatingTypes.hwbb.value;
            break;
        case 3:
            value = _enum.propertyHeatingTypes.radiant.value;
            break;
        case 4:
            value = _enum.propertyHeatingTypes.fuel.value;
            break;
        case 5:
            value = _enum.propertyHeatingTypes.other.value;
            break;
    }
    return value;
}
function formatCrossReferenceHeatingTypes(refid, htmlDesc) {
    refid = intOrDefault(refid);
    let value = "";
    switch (refid) {
        case 1:
            value = _enum.propertyHeatingTypes.fwa.value;
            break;
        case 2:
            value = _enum.propertyHeatingTypes.hwbb.value;
            break;
        case 3:
            value = _enum.propertyHeatingTypes.radiant.value;
            break;
        case 4:
            value = _enum.propertyHeatingTypes.fuel.value;
            break;
        case 5:
            value = _enum.propertyHeatingTypes.other.value;
            break;
    }
    if (value === htmlDesc || value === "Other") {
        value = "";
    }
    return string.format("{0} {1}", value, isNullOrWhiteSpace(htmlDesc) ? "" : (isNullOrWhiteSpace(value) ? htmlDesc : string.format("({0})", htmlDesc))).trim();
}
function getCoolingReferenceId(htmlDesc, crossRef) {
    let referenceId = 0;
    let first;
    let cool;
    if (crossRef) {
        first = crossRef.firstOrDefault(function (x) { return x.hasOwnProperty("PropCoolingType"); });
    }
    if (first && isNullOrWhiteSpace(htmlDesc)) {
        cool = first.PropCoolingType.firstOrDefault(function (x) { return x.HTMLDesc === "Other"; });
        if (cool) {
            htmlDesc = cool.HTMLDesc;//"Other"
        }
    }
    if (crossRef && first) {
        cool = first.PropCoolingType.firstOrDefault(function (x) { return x.HTMLDesc === htmlDesc; });
        if (cool) {
            referenceId = cool.ReferenceId;
        }
    } else {
        switch (htmlDesc) {
            case "Central Air Conditioning":
                referenceId = 1;
                break;
            case "Individual":
                referenceId = 2;
                break;
            case "Other":
                referenceId = 3;
                break;
            case "None":
                referenceId = 4;
                break;
        }
    }

    return referenceId;
}
function formatCrossReferenceCoolingTypeValue(refid) {
    refid = intOrDefault(refid);
    let value = "";
    switch (refid) {
        case 1:
            value = _enum.propertyCoolingTypes.centralAirConditioning.value;
            break;
        case 2:
            value = _enum.propertyCoolingTypes.individual.value;
            break;
        case 3:
            value = _enum.propertyCoolingTypes.other.value;
            break;
        case 4:
            value = _enum.propertyCoolingTypes.none.value;
            break;
    }
    return value;
}
function formatCrossReferenceCoolingTypes(refid, htmlDesc) {
    refid = intOrDefault(refid);
    let value = "";
    switch (refid) {
        case 1:
            value = _enum.propertyCoolingTypes.centralAirConditioning.value;
            break;
        case 2:
            value = _enum.propertyCoolingTypes.individual.value;
            break;
        case 3:
            value = _enum.propertyCoolingTypes.other.value;
            break;
        case 4:
            value = _enum.propertyCoolingTypes.none.value;
            break;
    }
    if (value === htmlDesc || value === "Other") {
        value = "";
    }
    return string.format("{0} {1}", value, isNullOrWhiteSpace(htmlDesc) ? "" : (isNullOrWhiteSpace(value) ? htmlDesc : string.format("({0})", htmlDesc))).trim();
}
function getAmenityObject(formattedAmenities) {
    var amenitiesObject = { count: null, description: null };
    if (isNullOrWhiteSpace(formattedAmenities) || typeof formattedAmenities !== "string") {
        amenitiesObject.count = intOrDefault(formattedAmenities);
        return amenitiesObject;
    }
    if (formattedAmenities.includes("(")) {
        let array = formattedAmenities.split("(");
        amenitiesObject.count = intOrDefault(array[0].trim());
        amenitiesObject.description = array[1].first(array[1].length - 1).trim();
    } else {
        amenitiesObject.count = intOrDefault(formattedAmenities);
    }
    return amenitiesObject;
}
function formatAmenities(count, description) {
    description = isNullOrWhiteSpace(description) ? "" : string.format("({0})", description);
    return string.format("{0} {1}", count, description).trim();
}
function getPropertyType(refid) {
    refid = intOrDefault(refid);
    let propertyType = { refId: refid, text: undefined, value: undefined };
    if (_orderDataBag.isGSE) {
        switch (refid) {
            case 1:
                propertyType = _enum.gsePropertyTypes.coOp;
                break;
            case 2:
                propertyType = _enum.gsePropertyTypes.commercial;
                break;
            case 3:
                propertyType = _enum.gsePropertyTypes.condo;
                break;
            case 4:
                propertyType = _enum.gsePropertyTypes.condoTel;
                break;
            case 5:
                propertyType = _enum.gsePropertyTypes.landOnly;
                break;
            case 6:
                propertyType = _enum.gsePropertyTypes.manufactured;
                break;
            case 7:
                propertyType = _enum.gsePropertyTypes.mobileLandAttached;
                break;
            case 8:
                propertyType = _enum.gsePropertyTypes.modular;
                break;
            case 9:
                propertyType = _enum.gsePropertyTypes.multiFamily2Unit;
                break;
            case 10:
                propertyType = _enum.gsePropertyTypes.multiFamily3Unit;
                break;
            case 11:
                propertyType = _enum.gsePropertyTypes.multiFamily4Unit;
                break;
            case 12:
                propertyType = _enum.gsePropertyTypes.singleFamilyAttached;
                break;
            case 13:
                propertyType = _enum.gsePropertyTypes.singleFamilyDetached;
                break;
            case 14:
                propertyType = _enum.gsePropertyTypes.townhome;
                break;
        }
    }
    else {
        switch (refid) {
            case 1:
                propertyType = _enum.propertyTypes.coOp;
                break;
            case 2:
                propertyType = _enum.propertyTypes.condominium;
                break;
            case 3:
                propertyType = _enum.propertyTypes.manufactured;
                break;
            case 4:
                propertyType = _enum.propertyTypes.mobile;
                break;
            case 5:
                propertyType = _enum.propertyTypes.modular;
                break;
            case 6:
                propertyType = _enum.propertyTypes.multiFamily;
                break;
            case 7:
                propertyType = _enum.propertyTypes.singleFamily;
                break;
            case 8:
                propertyType = _enum.propertyTypes.townhouse;
                break;
            case 9:
                propertyType = _enum.propertyTypes.vacantLand;
                break;
        }
    }

    return propertyType;
}
function getPropertySaleType(value) {
    let propertySaleType = { refId: 0, text: undefined, value: undefined };
    if (isNullOrWhiteSpace(value)) return propertySaleType;
    switch (value.toUpperCase()) {
        case "CRTORD":
            propertySaleType = _enum.propertySaleTypes.crtOrd;
            break;
        case "ESTATE":
            propertySaleType = _enum.propertySaleTypes.estate;
            break;
        case "NONARM":
            propertySaleType = _enum.propertySaleTypes.nonArm;
            break;
        case "RELO":
            propertySaleType = _enum.propertySaleTypes.relo;
            break;
        case "REO":
            propertySaleType = _enum.propertySaleTypes.reo;
            break;
        case "ARMLTH":
            propertySaleType = _enum.propertySaleTypes.armLth;
            break;
        case "RETAIL":
            propertySaleType = _enum.propertySaleTypes.retail;
            break;
        case "SHORT":
            propertySaleType = _enum.propertySaleTypes.short;
            break;
        case "OTHER":
            propertySaleType = _enum.propertySaleTypes.other;
            break;
    }

    return propertySaleType;
}
function getPropertyStyle(refid) {
    refid = intOrDefault(refid);
    let propertyStyle = { refId: refid, text: undefined, value: undefined };
    if (_orderDataBag.isGSE) {
        switch (refid) {
            case 1:
                propertyStyle = _enum.gsePropertyStyles.bungalowCottage;
                break;
            case 2:
                propertyStyle = _enum.gsePropertyStyles.cabin;
                break;
            case 3:
                propertyStyle = _enum.gsePropertyStyles.cape;
                break;
            case 4:
                propertyStyle = _enum.gsePropertyStyles.colonial;
                break;
            case 5:
                propertyStyle = _enum.gsePropertyStyles.commercial;
                break;
            case 6:
                propertyStyle = _enum.gsePropertyStyles.contemp;
                break;
            case 7:
                propertyStyle = _enum.gsePropertyStyles.farmHouse;
                break;
            case 8:
                propertyStyle = _enum.gsePropertyStyles.frame;
                break;
            case 9:
                propertyStyle = _enum.gsePropertyStyles.landOnly;
                break;
            case 10:
                propertyStyle = _enum.gsePropertyStyles.modular;
                break;
            case 11:
                propertyStyle = _enum.gsePropertyStyles.manufactured;
                break;
            case 12:
                propertyStyle = _enum.gsePropertyStyles.ranch;
                break;
            case 13:
                propertyStyle = _enum.gsePropertyStyles.splitBiLevel;
                break;
            case 14:
                propertyStyle = _enum.gsePropertyStyles.townhouse;
                break;
            case 15:
                propertyStyle = _enum.gsePropertyStyles.townhouseEnd;
                break;
            case 16:
                propertyStyle = _enum.gsePropertyStyles.townhouseMid;
                break;
            case 17:
                propertyStyle = _enum.gsePropertyStyles.triMultiLevel;
                break;
            case 18:
                propertyStyle = _enum.gsePropertyStyles.tudor;
                break;
            case 19:
                propertyStyle = _enum.gsePropertyStyles.victorian;
                break;
            case 20:
                propertyStyle = _enum.gsePropertyStyles.other;
                break;
        }
    }
    else {
        switch (refid) {
            case 1:
                propertyStyle = _enum.propertyStyles._1_Story;
                break;
            case 2:
                propertyStyle = _enum.propertyStyles._1_5_Story;
                break;
            case 3:
                propertyStyle = _enum.propertyStyles._2_Story;
                break;
            case 4:
                propertyStyle = _enum.propertyStyles._3_Plus_Story;
                break;
            case 5:
                propertyStyle = _enum.propertyStyles.attached;
                break;
            case 6:
                propertyStyle = _enum.propertyStyles.capeCod;
                break;
            case 7:
                propertyStyle = _enum.propertyStyles.colonial;
                break;
            case 8:
                propertyStyle = _enum.propertyStyles.contemporary;
                break;
            case 9:
                propertyStyle = _enum.propertyStyles.craftsman;
                break;
            case 10:
                propertyStyle = _enum.propertyStyles.duplex;
                break;
            case 11:
                propertyStyle = _enum.propertyStyles.farmhouse;
                break;
            case 12:
                propertyStyle = _enum.propertyStyles.georgian;
                break;
            case 13:
                propertyStyle = _enum.propertyStyles.highRise;
                break;
            case 14:
                propertyStyle = _enum.propertyStyles.logHome;
                break;
            case 15:
                propertyStyle = _enum.propertyStyles.lowRise;
                break;
            case 16:
                propertyStyle = _enum.propertyStyles.modern;
                break;
            case 17:
                propertyStyle = _enum.propertyStyles.raisedRanch;
                break;
            case 18:
                propertyStyle = _enum.propertyStyles.rambler;
                break;
            case 19:
                propertyStyle = _enum.propertyStyles.ranch;
                break;
            case 20:
                propertyStyle = _enum.propertyStyles.semiDetached;
                break;
            case 21:
                propertyStyle = _enum.propertyStyles.spanish;
                break;
            case 22:
                propertyStyle = _enum.propertyStyles.splitFoyer;
                break;
            case 23:
                propertyStyle = _enum.propertyStyles.splitLevel;
                break;
            case 24:
                propertyStyle = _enum.propertyStyles.tudor;
                break;
            case 25:
                propertyStyle = _enum.propertyStyles.vacantLand;
                break;
            case 26:
                propertyStyle = _enum.propertyStyles.victorian;
                break;
        }
    }

    return propertyStyle;
}

function setAutoSaveExecutionInterval(targetId) {
    if (_autoSaveTime > 0) {
        _autoSave = setInterval(function () {
            getDomElementById(targetId).trigger("click");
        }, _autoSaveTime);
    }
}
function setAutoSaveTime(toggleButtonOn) {
    var autoSaveTime = _orderDataBag.dataAutoSave;
    if (autoSaveTime > 0) {
        _autoSaveTime = moment.duration(autoSaveTime, "minutes").asMilliseconds();
    }
    if (toggleButtonOn) {
        setAutoSaveExecutionInterval("topBtnWizardSave");
    }
}

function ShowToastr(message = "Changes saved successfully.", position = "bottom-right", timeout = "5000", theme = "success", icon = "fa-check") {
    Notify(message, position, timeout, theme, icon, true);
}
function googleMapLoaded() { /*console.trace();*/ }
function selectOnFocus(event) {
    $(event.target).trigger("select");
}
/// REGION GLA
var negative_flag = false;
function checkNegative(ctrl) {
    if (negative_flag) {
        negative_flag = false;
        let ctrl_val = ctrl.value;
        if (!ctrl_val.lastIndexOf('-') == 0) {
            let is_negative = (ctrl_val.indexOf('-') == 0);
            ctrl.value = ctrl_val.split("-").join("");
            if (is_negative) {
                ctrl.value = '-' + ctrl.value;
            }
            return true;
        }
    }
    return false;
}
function adjCalcComp(input_ctrl, column) {
    if (checkNegative(input_ctrl) || intOrDefault(column) <= 0) {
        return;
    }
    let adjusted_val = 0;
    let gross_adjusted_val = 0;

    let comp_sale_price = getDomElementById(string.format("comp_{0}_sale_price_lbl", column)).text();
    let comp_sale_price_num = cleanCurrency(comp_sale_price);

    if (getDomElementById(string.format("comp_{0}_age_adj", column)).val() > 0) {
        getDomElementById(string.format("txtAgeComp{0}Reason", column)).text("");
    }
    if (getDomElementById(string.format("comp_{0}_site_adj", column)).val() > 0) {
        getDomElementById(string.format("txtSiteComp{0}Reason", column)).text("");
    }

    let dos_adj = intOrDefault(valueOrText(string.format("comp_{0}_dos_adj", column)));
    let location_adj = intOrDefault(valueOrText(string.format("comp_{0}_location_adj", column)));
    let view_adj = intOrDefault(valueOrText(string.format("comp_{0}_view_adj", column)));
    let site_adj = intOrDefault(valueOrText(string.format("comp_{0}_site_adj", column)));
    let style_adj = intOrDefault(valueOrText(string.format("comp_{0}_style_adj", column)));
    let type_adj = intOrDefault(valueOrText(string.format("comp_{0}_type_adj", column)));
    let quality_adj = intOrDefault(valueOrText(string.format("comp_{0}_quality_adj", column))); //JV
    let age_adj = intOrDefault(valueOrText(string.format("comp_{0}_age_adj", column)));
    let condition_adj = intOrDefault(valueOrText(string.format("comp_{0}_cond_adj", column)));
    let rms_adj = intOrDefault(valueOrText(string.format("comp_{0}_rms_adj", column)));
    let bath_adj = intOrDefault(valueOrText(string.format("comp_{0}_baths_adj", column)));
    let gla_adj = intOrDefault(valueOrText(string.format("comp_{0}_gla_adj", column)));
    let base_adj = intOrDefault(valueOrText(string.format("comp_{0}_base_adj", column)));
    let roombelowgrade_adj = intOrDefault(valueOrText(string.format("comp_{0}_rooms_below_grade_adj", column)));
    let ac_adj = intOrDefault(valueOrText(string.format("comp_{0}_ac_adj", column)));
    let heat_adj = intOrDefault(valueOrText(string.format("comp_{0}_heat_adj", column)));
    let garage_adj = intOrDefault(valueOrText(string.format("comp_{0}_garage_adj", column)));
    let amenities_adj = intOrDefault(valueOrText(string.format("comp_{0}_amenities_adj", column)));
    let other1_adj = intOrDefault(valueOrText(string.format("comp_{0}_other_1_adj", column)));
    let other2_adj = intOrDefault(valueOrText(string.format("comp_{0}_other_2_adj", column)));
    let other3_adj = intOrDefault(valueOrText(string.format("comp_{0}_other_3_adj", column)));

    adjusted_val = dos_adj + location_adj + view_adj + site_adj + style_adj + type_adj + quality_adj + age_adj + condition_adj + rms_adj + bath_adj + gla_adj + base_adj +
        roombelowgrade_adj + ac_adj + heat_adj + garage_adj + amenities_adj + other1_adj + other2_adj + other3_adj;

    //net adjustment
    getDomElementById(string.format("comp_{0}_net_adj_lbl", column)).html(adjusted_val.formatMoney(0));
    getDomElementById(string.format("comp_{0}_net_per_lbl", column)).html((100 * (adjusted_val / comp_sale_price_num)).toFixed(2) + "%");
    if (Math.abs((100 * (adjusted_val / comp_sale_price_num)).toFixed(2)) > 15) {
        getDomElementById(string.format("comp_{0}_net_per_lbl", column)).addClass("BorderHighlight");
    }
    else {
        getDomElementById(string.format("comp_{0}_net_per_lbl", column)).removeClass("BorderHighlight");
    }

    gross_adjusted_val = Math.abs(dos_adj) + Math.abs(location_adj) + Math.abs(view_adj) + Math.abs(site_adj) + Math.abs(style_adj) + Math.abs(type_adj) + Math.abs(quality_adj) +
        Math.abs(age_adj) + Math.abs(condition_adj) + Math.abs(rms_adj) + Math.abs(bath_adj) + Math.abs(gla_adj) + Math.abs(base_adj) + Math.abs(roombelowgrade_adj) +
        Math.abs(ac_adj) + Math.abs(heat_adj) + Math.abs(garage_adj) + Math.abs(amenities_adj) + Math.abs(other1_adj) + Math.abs(other2_adj) + Math.abs(other3_adj);

    //gross adjustment
    getDomElementById(string.format("comp_{0}_gross_adj_lbl", column)).html((comp_sale_price_num + adjusted_val).formatMoney(0));
    getDomElementById(string.format("comp_{0}_gross_per_lbl", column)).html((100 * (gross_adjusted_val / comp_sale_price_num)).toFixed(2) + "%");
    if (Math.abs((100 * (gross_adjusted_val / comp_sale_price_num)).toFixed(2)) > 25) {
        getDomElementById(string.format("comp_{0}_gross_per_lbl", column)).addClass("BorderHighlight");
    }
    else {
        getDomElementById(string.format("comp_{0}_gross_per_lbl", column)).removeClass("BorderHighlight");
    }
}
function calculateGlaAdjustment(subjGlaSqFtElementId, subjGlaValueElementId, compGlaValueElementId) {
    let subjectGlaPerSqFt = intOrDefault(valueOrText(subjGlaSqFtElementId));
    let subjectGlaValue = intOrDefault(textOrValue(subjGlaValueElementId));
    let compGlaValue = valueOrText(compGlaValueElementId).floatOrDefault();
    return subjectGlaPerSqFt * (subjectGlaValue - compGlaValue);
}
function automateGlaAdjValue(sequenceNo) {
    let subjGlaSqFtElementId = $(string.format("input[id*='subj_gla_per_'].glaPer.comp{0}", sequenceNo)).attr("id");
    let subjGlaValueElementId = $(string.format("span[id$='_gla_lbl'].subjElement.comp{0}", sequenceNo)).attr("id");
    let compGlaValueElementId = $(string.format("input[id$='{0}_gla_lbl'].compElement", sequenceNo)).attr("id");
    let subjectGlaPerSqFt = intOrDefault(valueOrText(subjGlaSqFtElementId));
    let subjectGlaValue = intOrDefault(textOrValue(subjGlaValueElementId));
    let compGlaValue = floatOrDefault(valueOrText(compGlaValueElementId));
    return subjectGlaPerSqFt * (subjectGlaValue - compGlaValue);
}
function finalizeSubmitGlaCalcAll(glaElement, minCol) {
    if (!_orderDataBag.withAdjustments) return;
    let origMinCol = minCol;
    let $compGlaValueCell;
    let $compGlaAdjCell;
    let compGlaValue;
    let $compGlaAdjElement;
    let subjectGlaPerSqFt;
    let subjectGlaValue;
    let $subjectCell;
    let $subjectGlaRow;
    let $othergla;
    let $target = $(glaElement);
    // subject data
    subjectGlaPerSqFt = intOrDefault(glaElement.value);
    subjectGlaValue = intOrDefault($target.closest("td").next().find("span").text());
    $subjectCell = $target.closest("td.subjectGlaCell");
    $subjectGlaRow = $subjectCell.closest("tr");
    glaElement.style.borderColor = subjectGlaPerSqFt === 0 ? "red" : "";
    // 1st comp
    $compGlaValueCell = $subjectGlaRow.find("td:nth-child(3)");// $subjectGlaRow.eq(3);
    $compGlaAdjCell = $subjectGlaRow.find("td:nth-child(4)");
    compGlaValue = intOrDefault($compGlaValueCell.find("span").text());
    $compGlaAdjElement = $compGlaAdjCell.find("input");
    $compGlaAdjElement.val(subjectGlaPerSqFt * (subjectGlaValue - compGlaValue));
    adjCalcComp($compGlaAdjElement[0], origMinCol++);
    // 2nd comp
    $compGlaValueCell = $subjectGlaRow.find("td:nth-child(5)");
    $compGlaAdjCell = $subjectGlaRow.find("td:nth-child(6)");
    compGlaValue = intOrDefault($compGlaValueCell.find("span").text());
    $compGlaAdjElement = $compGlaAdjCell.find("input");
    $compGlaAdjElement.val(subjectGlaPerSqFt * (subjectGlaValue - compGlaValue));
    adjCalcComp($compGlaAdjElement[0], origMinCol++);
    // 3rd comp
    $compGlaValueCell = $subjectGlaRow.find("td:nth-child(7)");
    $compGlaAdjCell = $subjectGlaRow.find("td:nth-child(8)");
    compGlaValue = intOrDefault($compGlaValueCell.find("span").text());
    $compGlaAdjElement = $compGlaAdjCell.find("input");
    $compGlaAdjElement.val(subjectGlaPerSqFt * (subjectGlaValue - compGlaValue));
    adjCalcComp($compGlaAdjElement[0], origMinCol++);
    // Trigger the other grid to execute same routine
    if (_orderDataBag.isGSE || _orderDataBag.is3to6Comp) {
        $othergla = $(string.format("input[data-thisgla='{0}']", $target.data("othergla")));
        if (intOrDefault($othergla.val()) !== subjectGlaPerSqFt) {
            $othergla.val(subjectGlaPerSqFt).trigger("change");
        }
    }
}
/// END REGION GLA

/// REGION BIAS
function checkBiasKeywordsViolation() {
    blurPage("Please wait while comments are validated");
    var d = $.Deferred();
    $.postJson("../../WebServices/DataAccessServiceJson.asmx/GetAllBiasViolationSources", { orderNo: intOrDefault(_orderDataBag.orderNo), itemNo: intOrDefault(_orderDataBag.itemNo), isUrar: _orderDataBag.isURAR })
        .fail(function (err) {
            unblurPage();
            ShowError(err.responseText);
            d.reject(string.empty);
        })
        .done(function (msg) {
            unblurPage();
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                let outerDivParent = createDomElement("div");
                let divTitle = createDomElement("div", [{ attr: "class", attrValue: "bold margin-t10 margin-b20 font-17" }]);
                divTitle.innerHTML = "Words that might suggest bias or be perceived as offensive detected:";
                outerDivParent.appendChild(divTitle);
                if (msg.Success) {
                    let data = isNullOrWhiteSpace(msg.Data) ? {} : JSON.parse(msg.Data);
                    msg.Result = isNullOrWhiteSpace(msg.Result) ? string.empty : msg.Result;
                    _bias.keywords = isNullOrWhiteSpace(msg.Bag) ? [] : msg.Bag;
                    if ($.isEmptyObject(data)) {
                        _bias.htmlData = string.empty;
                        d.resolve({ message: string.empty, showModal: false });
                    }
                    else {
                        let outerDiv = createDomElement("div", [{ attr: "class", attrValue: "min-height-400 height-400 max-height-400 outerDiv" }, { attr: "style", attrValue: "overflow-y: auto;" }]);
                        let style = createDomElement("style", [{ attr: "type", attrValue: "text/css" }]);
                        style.append(".modal-body {height: 480px !important;max-height: 480px !important;overflow-y: unset !important;}");
                        outerDiv.appendChild(style);
                        if (stringToBoolean(_orderDataBag.isURAR)) {
                            let innerDiv = createDomElement("div", [{ attr: "class", attrValue: "font-16 innerDiv" }]);
                            let ol = createDomElement("ol", [{ attr: "class", attrValue: "markertop" }]);
                            //
                            if (!$.isEmptyObject(data.AppDataUADSubject)) {
                                formatDetectedBias(data.AppDataUADSubject, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADContract)) {
                                formatDetectedBias(data.AppDataUADContract, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADNeighborhood)) {
                                formatDetectedBias(data.AppDataUADNeighborhood, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADSite)) {
                                formatDetectedBias(data.AppDataUADSite, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADImprovements)) {
                                formatDetectedBias(data.AppDataUADImprovements, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADSalesComparisonSubject)) {
                                formatDetectedBias(data.AppDataUADSalesComparisonSubject, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADReconciliation)) {
                                formatDetectedBias(data.AppDataUADReconciliation, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADAdditionalComments)) {
                                formatDetectedBias(data.AppDataUADAdditionalComments, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADCostApproach)) {
                                formatDetectedBias(data.AppDataUADCostApproach, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADIncomeApproach)) {
                                formatDetectedBias(data.AppDataUADIncomeApproach, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADProjectInformation)) {
                                formatDetectedBias(data.AppDataUADProjectInformation, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADInspectionImages)) {
                                formatDetectedBias(data.AppDataUADInspectionImages, outerDiv, innerDiv, ol, msg.Result);
                            }
                            if (!$.isEmptyObject(data.AppDataUADAdditionalAddendums)) {
                                formatDetectedBias(data.AppDataUADAdditionalAddendums, outerDiv, innerDiv, ol, msg.Result);
                            }
                            //
                            if ($.isEmptyObject(data.AppDataUADSubject) && $.isEmptyObject(data.AppDataUADContract) && $.isEmptyObject(data.AppDataUADNeighborhood) &&
                                $.isEmptyObject(data.AppDataUADSite) && $.isEmptyObject(data.AppDataUADImprovements) && $.isEmptyObject(data.AppDataUADSalesComparisonSubject) &&
                                $.isEmptyObject(data.AppDataUADReconciliation) && $.isEmptyObject(data.AppDataUADAdditionalComments) && $.isEmptyObject(data.AppDataUADCostApproach) &&
                                $.isEmptyObject(data.AppDataUADIncomeApproach) && $.isEmptyObject(data.AppDataUADProjectInformation) && $.isEmptyObject(data.AppDataUADInspectionImages) &&
                                $.isEmptyObject(data.AppDataUADAdditionalAddendums)) {
                                d.resolve({ message: string.empty, showModal: false });
                            }
                            else {
                                outerDivParent.appendChild(outerDiv);
                                _bias.htmlData = outerDivParent.outerHTML;
                                d.resolve({ message: outerDivParent.outerHTML, showModal: true });
                            }
                        }
                        else {
                            let innerDiv = createDomElement("div", [{ attr: "class", attrValue: "font-16 innerDiv" }]);
                            let ol = createDomElement("ol", [{ attr: "class", attrValue: "markertop" }]);
                            // AppDataReportDataMain
                            if (!$.isEmptyObject(data.AppDataReportDataMain)) {
                                formatDetectedBias(data.AppDataReportDataMain, outerDiv, innerDiv, ol, msg.Result);
                            }
                            // AppDataReportDataMainAdjustments
                            if (!$.isEmptyObject(data.AppDataReportDataMainAdjustments)) {
                                formatDetectedBias(data.AppDataReportDataMainAdjustments, outerDiv, innerDiv, ol, msg.Result);
                            }
                            //
                            if (!$.isEmptyObject(data.AppDataRepairAddendum)) {
                                formatDetectedBias(data.AppDataRepairAddendum, outerDiv, innerDiv, ol, msg.Result);
                            }
                            // AppDataInspection
                            if (!$.isEmptyObject(data.AppDataInspection)) {
                                let divTitle = createDomElement("div", [{ attr: "class", attrValue: "bold margin-t10 margin-b20 font-17" }]);
                                divTitle.innerHTML = "Inspection Addendum Comments:";
                                //outerDiv.appendChild(divTitle);
                                let innerDiv2 = createDomElement("div", [{ attr: "class", attrValue: "font-16 innerDiv" }]);
                                let ol2 = createDomElement("ol", [{ attr: "class", attrValue: "markertop" }]);
                                formatDetectedBias(data.AppDataInspection, outerDiv, innerDiv2, ol2, msg.Result, divTitle);
                            }
                            //CondoAddendum
                            if (!$.isEmptyObject(data.AppDataReportDataMainCondoData)) {
                                let divTitle = createDomElement("div", [{ attr: "class", attrValue: "bold margin-t10 margin-b20 font-17" }]);
                                divTitle.innerHTML = "Condo Addendum Comments:";
                                //outerDiv.appendChild(divTitle);
                                let innerDiv2 = createDomElement("div", [{ attr: "class", attrValue: "font-16 innerDiv" }]);
                                let ol2 = createDomElement("ol", [{ attr: "class", attrValue: "markertop" }]);
                                formatDetectedBias(data.AppDataReportDataMainCondoData, outerDiv, innerDiv2, ol2, msg.Result, divTitle);
                            }
                            //
                            if ($.isEmptyObject(data.AppDataReportDataMain) && $.isEmptyObject(data.AppDataReportDataMainAdjustments) && $.isEmptyObject(data.AppDataRepairAddendum) && $.isEmptyObject(data.AppDataInspection) && $.isEmptyObject(data.AppDataReportDataMainCondoData)) {
                                d.resolve({ message: string.empty, showModal: false });
                            }
                            else {
                                outerDivParent.appendChild(outerDiv);
                                _bias.htmlData = outerDivParent.outerHTML;
                                d.resolve({ message: outerDivParent.outerHTML, showModal: true });
                            }
                        }
                    }
                }
                else {
                    ShowError(msg.Result);
                    d.reject({ message: string.empty, showModal: false });
                }
            }
        });
    return d.promise();
}
function formatDetectedBias(data, outerDiv, innerDiv, ol, biasWhiteList, divTitle) {
    if (isNullOrWhiteSpace(biasWhiteList)) { biasWhiteList = ""; }
    for (var prop in data) {
        let htmlLabel = string.format(" {0}", prop);
        if (Object.prototype.hasOwnProperty.call(data, prop)) {
            let value = data[prop];
            let seedValues = value.select(x => x.BiasKey).filter(x => !biasWhiteList.includes(x.trim()));
            seedValues = seedValues.select(x => " " + x).sort().toString();
            if (isNullOrWhiteSpace(seedValues)) continue;
            let fieldName = value[0].FieldName;
            let comments = value[0].Comments;
            let tableName = value[0].TableName;
            let li = createDomElement("li", [{ attr: "class", attrValue: "margin-tb20 markertop" }, { attr: "style", attrValue: "line-height:20px;" }]);
            if (_orderDataBag.suffix !== "VM") {
                li.innerHTML = string.format("<span class='underline'>{0}</span>: <span class='font-14 font-n'>{1}</span>", htmlLabel, seedValues);
            } else {
                li.innerHTML = string.format("<a class='cursor-p' onclick='checkBiasKeywords(event)' data-tablename='{0}' data-fieldname='{1}' data-htmllabel='{2}' data-seedvalues='{4}' data-whitelist='{5}'>{2}<span class='hide'>{3}</span></a>: <span class='font-14 font-n'>{4}</span>", tableName, fieldName, htmlLabel, comments, seedValues, biasWhiteList);
            }
            ol.appendChild(li);
        }
    }
    if (ol.children.length != 0) {
        if (divTitle != undefined) {
            outerDiv.appendChild(divTitle);
        }
        innerDiv.appendChild(ol);
        outerDiv.appendChild(innerDiv);
    }
}
function checkBiasKeywords(event) {
    let tableName = $(event.target).attr("data-tablename");
    let fieldName = $(event.target).attr("data-fieldname");
    let htmlLabel = $(event.target).attr("data-htmllabel");
    let whiteList = $(event.target).attr("data-whitelist");
    //let seedValues = $(event.target).attr("data-seedvalues");
    let message = $(event.target).find("span").text();
    bootbox.prompt({
        title: "Bias words correction!",
        onEscape: false,
        centerVertical: true,
        value: message,
        className: "bootbox-body-bias-correction",
        inputType: "textarea",
        buttons: {
            confirm: { label: "Save", className: "btn-primary width-125 font-16 biasKeywordBtn" },
            cancel: { label: "Cancel", className: "btn-danger width-125 font-16 float-l" }
        },
        callback: function (response) {
            if (!isNullOrUndefined(response)) {
                const fieldValue = response;// valueOrText('biasKeywordText');
                let url = "../../WebServices/DataAccessServiceJson.asmx/UpdateSingleField";
                let jsonText = $.toJSON({
                    tableName: tableName,
                    fieldName: fieldName,
                    fieldValue: fieldValue,
                    whereClause: string.format("OrderNo = {0} AND ItemNo = {1}", _orderDataBag.orderNo, _orderDataBag.itemNo)
                });
                ajaxSubmit(url, jsonText, function (msg) {
                    msg = $.parseJSON(msg.d);
                    if (msg.Success) {
                        _bias.isDirty = true;
                        let $ol = $(event.target).closest("ol");
                        let remainingKeys = getBiasKeywordsFrom(fieldValue, whiteList);
                        if (remainingKeys.any()) {
                            let newSeedValues = replaceBoth(remainingKeys.map(x => " " + x), ",");
                            $(event.target).next().text(newSeedValues);
                            //$(event.target).find("span").html(newSeedValues);
                            $(event.target).find("span").text(fieldValue);
                            $(event.target).attr("data-seedvalues", newSeedValues);
                        } else {
                            $(event.target).closest("li").remove();
                            let remaining = $ol.children().length;
                            if (remaining === 0) {
                                $ol.closest("div").html("<p class='font-13 align-c margin-t20 gray'>No bias keywords detected.</p>");
                            }
                        }
                    }
                    else {
                        ShowError(msg.Result);
                    }
                }, function (error, errorType, message) {
                    ShowError(string.format("Failed to update the '{0}' comment", htmlLabel));
                });
            }
        }
    }).on("shown.bs.modal", function (evt) {
        $('textarea.bootbox-input-textarea')
            .attr("id", "biasKeywordText")
            .addClass("allowenterkeyboard font-n")
            .closest("div.bootbox-body")
            .prepend("<p class='bold font-16 display-ib'>Please correct the following bias keywords:</p>");
    });
}
function toggleBiasSaveButton($btn, seeds, text) {
    if (isNullOrWhiteSpace(text)) {
        $btn.attr("disabled", "disabled");
    } else {
        $btn.removeAttr("disabled");
    }
}
function hasBiasKeyword(text, seeds) {
    let biased = false;
    if (!exists(seeds)) {
        seeds = _bias.keywords;
    }
    $.each(seeds, (_, seed) => {
        seed = seed.trim();
        if (checkExactMatch(text, seed)) {
            biased = true;
            return false;
        }
    });
    return biased;
}
function getBiasKeywordsFrom(text, whiteList) {
    let biased = [];
    whiteList = whiteList.toUpperCase();
    if (isNullOrWhiteSpace(text)) return biased;
    $.each(_bias.keywords, (_, key) => {
        key = key.trim();
        if (checkExactMatch(text, key) && !whiteList.contains(key.toUpperCase())) {
            biased.push(key);
        }
    });
    return biased.sort();
}
/// END REGION BIAS

function gwGetEnumerationDataAsync(productCode) {
    let d = $.Deferred();
    $.postJson(getAjaxUrl("GWGetEnumerationData"), { productCode: productCode })
        .fail(function (err) {
            ShowToastr(err.responseText, "bottom-right", "5000", "danger", "fa-times");
            d.reject(string.empty);
        })
        .done(function (msg) {
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                if (msg.Success) {
                    d.resolve(isNullOrWhiteSpace(msg.Data) ? [] : JSON.parse(msg.Data));
                }
                else {
                    ShowToastr(msg.Result, "bottom-right", "5000", "danger", "fa-times");
                    d.reject(msg.Result);
                }
            }
        });
    return d.promise();
}
function gwGetInspectionGSEDataAsync(vendorId, orderNo, itemNo) {
    let d = $.Deferred();
    $.postJson(getAjaxUrl("GWGetInspectionGSEData"), { vendorId: vendorId, orderNo: orderNo, itemNo: itemNo })
        .fail(function (err) {
            ShowToastr(err.responseText, "bottom-right", "5000", "danger", "fa-times");
            d.reject(string.empty);
        })
        .done(function (msg) {
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                if (msg.Success) {
                    d.resolve(isNullOrWhiteSpace(msg.Data) ? [] : JSON.parse(msg.Data));
                }
                else {
                    ShowToastr(msg.Result, "bottom-right", "5000", "danger", "fa-times");
                    d.reject(msg.Result);
                }
            }
        });
    return d.promise();
}
function gwGetInspEnumGSEDataAsync(vendorId, orderNo, itemNo, productCode) {
    let d = $.Deferred();
    $.postJson(getAjaxUrl("GWGetInspEnumGSEData"), { vendorId: vendorId, orderNo: orderNo, itemNo: itemNo, productCode: productCode })
        .fail(function (err) {
            ShowToastr(err.responseText, "bottom-right", "5000", "danger", "fa-times");
            d.reject(string.empty);
        })
        .done(function (msg) {
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                if (msg.Success) {
                    d.resolve(msg.Data);
                }
                else {
                    ShowToastr(msg.Result, "bottom-right", "5000", "danger", "fa-times");
                    d.reject(msg.Result);
                }
            }
        });
    return d.promise();
}
function gwSaveInspectionGSEDataAsync(request) {
    let d = $.Deferred();
    $.postJson(getAjaxUrl("GWSaveInspectionGSEData"), { request: request })
        .fail(function (err) {
            ShowToastr(err.responseText, "bottom-right", "5000", "danger", "fa-times");
            d.reject(string.empty);
        })
        .done(function (msg) {
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                if (msg.Success) {
                    d.resolve(msg.Data);
                }
                else {
                    //ShowToastr(msg.Result, "bottom-right", "5000", "danger", "fa-times");
                    d.reject(msg.Result);
                }
            }
        });
    return d.promise();
}
function submitGseToHomeMortgage(homeMortgage) {
    let d = $.Deferred();
    $.postJson(getAjaxUrl("SubmitGseToHomeMortgage"), { orderNo: _orderDataBag.orderNo, itemNo: _orderDataBag.itemNo, homeMortgage: homeMortgage })
        .fail(function (err) {
            err.ErrorMessage = "Submission failed!";
            d.reject(err);
        })
        .done(function (msg) {
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                if (msg.Success) {
                    msg.Result = "Submission succeeded!";
                    d.resolve(msg);
                }
                else {
                    msg.ErrorMessage = "Submission failed!";
                    d.reject(msg);
                }
            }
        });
    return d.promise();
}
function generateGseInspectionReport(preview, callback) {
    blurPage(preview ? "Please wait while the preview report is generated" : "Please wait while the final report is generated");
    ajaxSubmit(getAjaxUrl("GenerateGseInspectionReport"), $.toJSON({
        orderNo: _orderDataBag.orderNo,
        itemNo: _orderDataBag.itemNo,
        productCode: _orderDataBag.productCode,
        referrer: location.href.toLowerCase().replace("ordertracking", "inspections"),
        preview: preview
    }), function (msg) {
        msg = $.parseJSON(msg.d);
        if (msg.Success) {
            unblurPage();
            if ($.isFunction(callback)) {
                callback(msg.Data);
            }
        }
        else {
            unblurPage();
            ShowError(msg.Result);
        }
    },
        function (error, errorType, message) {
            unblurPage();
            ShowError("Generating GSE Inspection Report failed. \n" + message);
        });
}
function regenerateGseInspectionReport(callback) {
    blurPage("Please wait while the report is regenerated");
    ajaxSubmit(getAjaxUrl("RegenerateGseInspectionReport"), $.toJSON({
        orderNo: _orderDataBag.orderNo,
        itemNo: _orderDataBag.itemNo,
        productCode: _orderDataBag.productCode,
        referrer: location.href.toLowerCase().replace("ordertracking", "inspections")
    }), function (msg) {
        msg = $.parseJSON(msg.d);
        if (msg.Success) {
            unblurPage();
            if ($.isFunction(callback)) {
                callback(msg.Data);
            }
        }
        else {
            unblurPage();
            ShowError(msg.Result);
        }
    },
        function (error, errorType, message) {
            unblurPage();
            ShowError("Regenerating GSE Inspection Report failed. \n" + message);
        });
}

function includeOnEnvChecked(element, rowId) {
    clearTooltips();
    let isChecked = $(element).prop("checked");
    ajaxSubmit(getAjaxUrl("ToggleIncludeOnENV"), $.toJSON({ rowId: rowId, isChecked: isChecked }), function (msg) {
        msg = $.parseJSON(msg.d);
        if (msg.Success) {
            let gseMitIncludedImagesCount = intOrDefault(valueOrText("hdnGseMitIncludedImages"));
            if (isChecked) {
                gseMitIncludedImagesCount++;
            } else {
                gseMitIncludedImagesCount--;
            }
            getDomElementById("hdnGseMitIncludedImages").val(gseMitIncludedImagesCount);
            let overflowCount = gseMitIncludedImagesCount - _gseMitMaxAllowedImages;
            if (overflowCount <= 0) {
                overflowCount = 0;
            }
            if (_orderDataBag.suffix === "IU") {
                getDomElementById("spanVNImgOverEnvLimitCount").text(overflowCount);
            } else {
                getDomElementById("gseMitImageCounter").text(overflowCount);
            }
            $(".controlHasChanged").removeClass("controlHasChanged");
        }
    },
        function (error, errorType, message) {
            ShowToastr(error.responseText, "bottom-right", "5000", "danger", "fa-times");
            $(".controlHasChanged").removeClass("controlHasChanged");// resetOrigFormData();
        });
}

function gwImageRequestDTO(sortOrder, imageTitle = "", origin = "web", finishedAreaAboveGrade = 0) {
    return {
        AccurateUser: null,
        ImageMetaData: {
            OrderNo: _orderDataBag.orderNo,
            ItemNo: _orderDataBag.itemNo,
            SortOrder: intOrDefault(sortOrder),
            Title: stringOrDefault(imageTitle),
            Origin: stringOrDefault(origin),
            FinishedAreaAboveGrade: finishedAreaAboveGrade
        }
    };
}
function rapidSketchAppClosed(callback) {
    if (callback) {
        try {
            window[callback]();
        }
        catch { }
    }
}
function openRapidSketchApp(buildingId, useDesktop, callback) {
    if (intOrDefault(buildingId) === 0) {
        buildingId = 1;
    }
    let sketchURL = string.format('{0}Site/VendorServices/GwSketch.aspx?on={1}&it={2}', _orderDataBag.baseURI, _orderDataBag.orderNo, _orderDataBag.itemNo);
    if (useDesktop) {
        sketchURL = string.format("{0}Site/VendorServices/Shells/RSSplash.aspx?serviceURL={0}Webservices/SketchService.asmx&sketchID={1}~{2}~{3}~{4}~{5}~{6}&callback={7}",
            _orderDataBag.baseURI, _orderDataBag.userName, _orderDataBag.contactId, _orderDataBag.orderNo, _orderDataBag.itemNo, buildingId, _orderDataBag.productCode, callback);
    }
    return window.open(sketchURL, "_blank", "toolbar=no,scrollbars=yes,resizable=yes");
}
//Due to an obscure bug in the underlying WinINET InternetGetCookie implementation,
//IE’s document.cookie will not return a cookie if it was set with a path attribute containing a filename.
//This means one cannot set a path using window.location.pathname
function setOrUpdateCookie(name, value = "", day = -1, path = window.location.pathname) {
    path = isNullOrWhiteSpace(path) ? "/" : path;
    $.postJson(getAjaxUrl("SetOrUpdateCookie"), { name: name, value: value, day: day, path: path })
        .fail(function (err) {
            ShowToastr("Could not set or update cookie", "bottom-right", "5000", "danger", "fa-times");
        })
        .done(function (msg) {
            if (exists(msg)) {
                msg = $.parseJSON(msg.d);
                if (msg.Success) {
                    document.cookie = msg.Data;
                }
                else {
                    ShowToastr("Could not set or update cookie", "bottom-right", "5000", "danger", "fa-times");
                }
            }
        });
}

function scrollToTopPage(duration = 1000, easing = "swing") {
    scrollElementToView("a#pagetop", "body", duration, easing);
}
function scrollBackToPreviousView(duration = 1000, easing = "swing") {
    $("html, body").animate({ scrollTop: _winScrollPos }, { duration: duration, easing: easing });
    _winScrollPos = 0;
}
function refreshParentOpener(force) {
    if (window.opener) {
        if (force) {
            window.opener.location.reload();
        } else {
            if (!stringToBoolean(window.opener.getSessionStorage("ManualRefreshWQ"))) {
                window.opener.location.reload();
            }
        }
    }
}
function changeDateFormatSeparator(separator) {
    return _vnDate.monthDayYearHourMinSec.replaceAll("/", separator);
}
function toggleAllWidgets(element, parentSelector) {
    clearTooltips();
    $.each($(parentSelector).find("i[class*='fa-chevron']").toArray(), function (_, chevron) { $(chevron).trigger("click"); });
    $(element).toggleClass("fa-folder-open-o fa-folder-o");
}

function submitToRestBAiReview(element) {
    clearTooltips();
    $(element).find("i").toggleClass("fa-upload fa-spin fa-spinner gray");
    blurPage("<div class='container text-center'><div class='row'><div class='col-lg-12'><div style='margin-top:10px;'>Please wait while report is sent to RestB.ai</div></div></div><div class='row margin-t10'><div class='col-lg-4'></div><div class='col-lg-1'><div class='fromordernodiv' style='display:inline-block;border:1px solid;padding: 4px 10px;border-radius:10px;'>ValueNet</div></div><div class='col-lg-2'><div class='bounceX margin-lr30 height-28' style='display:inline-block;'><i class='fa fa-long-arrow-right fa-2x' style='position: relative;top:7px;'></i></div></div><div class='col-lg-1'><div class='toordernodiv' style='display:inline-block;border:1px solid;padding: 4px 10px;border-radius:10px;'>RestB.ai</div></div><div class='col-lg-4'></div></div></div>", true);
    $("#spinnerContainer > div ").css("height", "145px");
    $.when(submitRestBAiReview()).fail(function (response) {
        $(element).find("i").toggleClass("fa-upload fa-spin fa-spinner gray");
        unblurPage();
        ShowError(response.ErrorMessage);
    }).done(function (response) {
        if (response.Data.refreshReport === true) {
            blurPage('Submission succeeded! Page will now be reloaded to retrieve the new report.');
            setTimeout(function () {
                location.reload();
            }, 2000);
        } else {
            $(element).find("i").toggleClass("fa-upload fa-spin fa-spinner gray");
            unblurPage();
            $("#gseSubmissionResults").html(response.Result);
            $("#divGseSubmissionResult").modal("show");
            getDomElementById("restBAiQCReportLink").show();
            var docPath = encodeURI("../../viewer.aspx?attachment=false&rowID=" + response.Data.document);
            getDomElementById("restBAiQCReportLink").attr("href", docPath);
        }
    });
}
function submitRestBAiReview() {
    var d = $.Deferred();
    $.postJson("../../WebServices/DataAccessServiceJson.asmx/SubmitRestBAiReview", { orderNo: _orderDataBag.orderNo, itemNo: _orderDataBag.itemNo, reportId: _orderDataBag.reportId }).fail(function (err) {
        err.ErrorMessage = "Submission failed!";
        d.reject(err);
    }).done(function (msg) {
        if (exists(msg)) {
            msg = $.parseJSON(msg.d);
            if (msg.Success) {
                msg.Result = "Submission succeeded!";
                d.resolve(msg);
            } else {
                msg.ErrorMessage = "Submission failed!";
                d.reject(msg);
            }
        }
    });
    return d.promise();
}
function updateGeoCodeRefresh(latitude, longitude) {
    var jsonText = $.toJSON({ orderNumber: _orderDataBag.orderNo, longitude: longitude, latitude: latitude, transactionId: $("#" + window.dm_TransactionId).val() });
    ajaxSubmit("../../WebServices/DataAccessServiceJson.asmx/OrderMasterUpdateLongLat", jsonText, function (msg) {
        if (msg) {
            msg = $.parseJSON(msg.d);
            $("#" + window.dm_TransactionId).val(msg.TransactionId);
            if (msg.Success) {
                window.blurPage("Please wait while the new coordinates are saved.");
                window.location.reload();
            } else {
                Notify("Failed to update the property's GeoCode coordinates.", "bottom-right", "5000", "danger", "fa-times", true);
            }
        }
    });
}